/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class LimitDistinctProjection
extends Projection {
    private final int limit;
    private final List<Symbol> outputs;
    private final RowGranularity granularity;

    public LimitDistinctProjection(int limit, List<Symbol> outputs, RowGranularity granularity) {
        this.limit = limit;
        this.outputs = outputs;
        this.granularity = granularity;
    }

    public LimitDistinctProjection(StreamInput in) throws IOException {
        this.limit = in.readVInt();
        this.outputs = Symbols.fromStream(in);
        this.granularity = RowGranularity.fromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.limit);
        Symbols.toStream(this.outputs, out);
        RowGranularity.toStream(this.granularity, out);
    }

    @Override
    public RowGranularity requiredGranularity() {
        return this.granularity;
    }

    public int limit() {
        return this.limit;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.LIMIT_DISTINCT;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitLimitDistinct(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitDistinctProjection that = (LimitDistinctProjection)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (!this.outputs.equals(that.outputs)) {
            return false;
        }
        return this.granularity == that.granularity;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.limit;
        result = 31 * result + this.outputs.hashCode();
        result = 31 * result + this.granularity.hashCode();
        return result;
    }
}

