/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.data.Bucket;
import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.engine.PagingUnsupportedResultListener;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.transport.JobResponse;
import java.util.List;
import org.elasticsearch.action.ActionListener;

final class BucketForwarder
implements ActionListener<JobResponse> {
    private final List<PageBucketReceiver> bucketReceivers;
    private final int bucketIdx;
    private final InitializationTracker initializationTracker;

    BucketForwarder(List<PageBucketReceiver> bucketReceivers, int bucketIdx, InitializationTracker initializationTracker) {
        assert (!bucketReceivers.isEmpty()) : "bucketReceivers must not be empty";
        this.bucketReceivers = bucketReceivers;
        this.bucketIdx = bucketIdx;
        this.initializationTracker = initializationTracker;
    }

    @Override
    public void onResponse(JobResponse jobResponse) {
        this.initializationTracker.jobInitialized();
        List<StreamBucket> directResponses = jobResponse.getDirectResponses(this.bucketReceivers.getFirst().streamers());
        for (int i = 0; i < this.bucketReceivers.size(); ++i) {
            PageBucketReceiver pageBucketReceiver = this.bucketReceivers.get(i);
            Bucket bucket = directResponses.get(i);
            assert (bucket != null) : "buckets must contain a non-null bucket at idx=" + i;
            pageBucketReceiver.setBucket(this.bucketIdx, bucket, true, PagingUnsupportedResultListener.INSTANCE);
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.initializationTracker.jobInitializationFailed(e);
        for (PageBucketReceiver pageBucketReceiver : this.bucketReceivers) {
            pageBucketReceiver.kill(e);
        }
    }
}

