/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;

public class FirstColumnConsumers {
    public static Collector<Row, ?, ?> getCollector(SelectSymbol.ResultType resultType, DataType<?> dataType, RamAccounting ramAccounting) {
        if (resultType == SelectSymbol.ResultType.SINGLE_COLUMN_SINGLE_VALUE) {
            return SingleValue.INSTANCE;
        }
        return new AllValues(ramAccounting, dataType);
    }

    private static class SingleValue
    implements Collector<Row, Object[], Object> {
        public static final SingleValue INSTANCE = new SingleValue();
        private static final Object SENTINEL = new Object();

        private SingleValue() {
        }

        @Override
        public Supplier<Object[]> supplier() {
            return () -> new Object[]{SENTINEL};
        }

        @Override
        public BiConsumer<Object[], Row> accumulator() {
            return (agg, row) -> {
                if (agg[0] != SENTINEL) {
                    throw new UnsupportedOperationException("Subquery returned more than 1 row when it shouldn't.");
                }
                agg[0] = row.get(0);
            };
        }

        @Override
        public BinaryOperator<Object[]> combiner() {
            throw new IllegalStateException("Combine is not implemented on this collector");
        }

        @Override
        public Function<Object[], Object> finisher() {
            return agg -> {
                if (agg[0] == SENTINEL) {
                    return null;
                }
                return agg[0];
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    private static class AllValues
    implements Collector<Row, List<Object>, List<Object>> {
        private final RamAccounting ramAccounting;
        private final DataType<Object> dataType;

        private AllValues(RamAccounting ramAccounting, DataType<?> dataType) {
            this.ramAccounting = ramAccounting;
            this.dataType = dataType;
        }

        @Override
        public Supplier<List<Object>> supplier() {
            return () -> new ArrayList(1);
        }

        @Override
        public BiConsumer<List<Object>, Row> accumulator() {
            return (agg, row) -> {
                Object value = row.get(0);
                this.ramAccounting.addBytes(this.dataType.valueBytes(value));
                agg.add(value);
            };
        }

        @Override
        public BinaryOperator<List<Object>> combiner() {
            throw new IllegalStateException("Combine is not implemented on this collector");
        }

        public UnaryOperator<List<Object>> finisher() {
            return UnaryOperator.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

