/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.role.Role;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class InterceptingRowConsumer
implements RowConsumer {
    private static final Logger LOGGER = LogManager.getLogger(InterceptingRowConsumer.class);
    private final UUID jobId;
    private final RowConsumer consumer;
    private final ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction;
    private final InitializationTracker initTracker;

    InterceptingRowConsumer(UUID jobId, RowConsumer consumer, InitializationTracker initTracker, ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction) {
        this.jobId = jobId;
        this.consumer = consumer;
        this.initTracker = initTracker;
        this.killNodeAction = killNodeAction;
    }

    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        this.consumer.accept(iterator, failure);
        this.initTracker.future.whenComplete((void_, err) -> {
            Throwable t = SQLExceptions.unwrap(failure == null ? err : failure);
            if (t == null) {
                return;
            }
            if (iterator != null) {
                iterator.kill(t);
            }
            KillJobsNodeRequest killRequest = new KillJobsNodeRequest(List.of(), List.of(this.jobId), Role.CRATE_USER.name(), "An error was encountered: " + String.valueOf(t));
            this.killNodeAction.execute(killRequest).whenComplete((resp, killErr) -> {
                if (killErr == null) {
                    LOGGER.trace("Killed {} contexts for jobId={} due to failure={}", (Object)resp.numKilled(), (Object)this.jobId, (Object)t);
                } else {
                    LOGGER.trace("Failed to kill jobId={} due to failure={}", (Object)this.jobId, (Object)t);
                }
            });
        });
    }

    public CompletableFuture<?> completionFuture() {
        return this.consumer.completionFuture();
    }

    public String toString() {
        return "InterceptingRowConsumer{initTracker=" + String.valueOf(this.initTracker) + ", jobId=" + String.valueOf(this.jobId) + ", consumer=" + String.valueOf(this.consumer) + "}";
    }
}

