/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationContext;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.GroupingCollector;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.memory.MemoryManager;
import java.util.List;
import java.util.stream.Collector;
import org.elasticsearch.Version;

public class GroupingProjector
implements Projector {
    private final Collector<Row, ?, Iterable<Row>> collector;

    public GroupingProjector(List<? extends Symbol> keys, List<Input<?>> keyInputs, CollectExpression<Row, ?>[] collectExpressions, AggregateMode mode, AggregationContext[] aggregations, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
        assert (keys.size() == keyInputs.size()) : "number of key types must match with number of key inputs";
        AggregationFunction[] functions = new AggregationFunction[aggregations.length];
        Input[][] inputs = new Input[aggregations.length][];
        Input[] filters = new Input[aggregations.length];
        for (int i = 0; i < aggregations.length; ++i) {
            AggregationContext aggregation = aggregations[i];
            functions[i] = aggregation.function();
            inputs[i] = aggregation.inputs();
            filters[i] = aggregation.filter();
        }
        if (keys.size() == 1) {
            Symbol key = keys.get(0);
            this.collector = GroupingCollector.singleKey(collectExpressions, mode, functions, inputs, filters, ramAccounting, memoryManager, minNodeVersion, keyInputs.get(0), key.valueType());
        } else {
            this.collector = GroupingCollector.manyKeys(collectExpressions, mode, functions, inputs, filters, ramAccounting, memoryManager, minNodeVersion, keyInputs, Symbols.typeView(keys));
        }
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, this.collector);
    }

    public Collector<Row, ?, Iterable<Row>> getCollector() {
        return this.collector;
    }

    public boolean providesIndependentScroll() {
        return true;
    }
}

