/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;

public final class ArrayAgg
extends AggregationFunction<List<Object>, List<Object>> {
    public static final String NAME = "array_agg";
    public static final Signature SIGNATURE = Signature.builder("array_agg", FunctionType.AGGREGATE).argumentTypes(TypeSignature.parse("E")).returnType(TypeSignature.parse("array(E)")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build();
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final DataType<Object> elementType;

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, ArrayAgg::new);
    }

    public ArrayAgg(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.elementType = boundSignature.argTypes().get(0);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public List<Object> newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        return new ArrayList<Object>();
    }

    @Override
    public List<Object> iterate(RamAccounting ramAccounting, MemoryManager memoryManager, List<Object> state, Input<?> ... args) throws CircuitBreakingException {
        Object value = args[0].value();
        ramAccounting.addBytes(this.elementType.valueBytes(value));
        state.add(value);
        return state;
    }

    @Override
    public List<Object> reduce(RamAccounting ramAccounting, List<Object> state1, List<Object> state2) {
        state1.addAll(state2);
        return state1;
    }

    @Override
    public List<Object> terminatePartial(RamAccounting ramAccounting, List<Object> state) {
        return state;
    }

    @Override
    public DataType<?> partialType() {
        return this.boundSignature.returnType();
    }
}

