/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.SortedNumericDocValueAggregator;
import io.crate.execution.engine.aggregation.statistics.Variance;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public abstract class StandardDeviationAggregation<V extends Variance>
extends AggregationFunction<V, Double> {
    private final Signature signature;
    private final BoundSignature boundSignature;

    public StandardDeviationAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public V iterate(RamAccounting ramAccounting, MemoryManager memoryManager, V state, Input<?> ... args) throws CircuitBreakingException {
        Number value;
        if (state != null && (value = (Number)args[0].value()) != null) {
            ((Variance)state).increment(value.doubleValue());
        }
        return state;
    }

    @Override
    public V reduce(RamAccounting ramAccounting, V state1, V state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        ((Variance)state1).merge((Variance)state2);
        return state1;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public V removeFromAggregatedState(RamAccounting ramAccounting, V previousAggState, Input<?>[] stateToRemove) {
        Number value;
        if (previousAggState != null && (value = (Number)stateToRemove[0].value()) != null) {
            ((Variance)previousAggState).decrement(value.doubleValue());
        }
        return previousAggState;
    }

    @Override
    public Double terminatePartial(RamAccounting ramAccounting, V state) {
        double result = ((Variance)state).result();
        return Double.isNaN(result) ? null : Double.valueOf(result);
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        return switch (reference.valueType().id()) {
            case 2, 8, 9, 10, 11, 15 -> new SortedNumericDocValueAggregator<Variance>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                ramAccounting.addBytes((long)Variance.fixedSize());
                return (Variance)this.newState((RamAccounting)ramAccounting, (Version)version, (MemoryManager)memoryManager);
            }, (ramAccounting, values, state) -> state.increment(values.nextValue()));
            case 7 -> new SortedNumericDocValueAggregator<Variance>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                ramAccounting.addBytes((long)Variance.fixedSize());
                return (Variance)this.newState((RamAccounting)ramAccounting, (Version)version, (MemoryManager)memoryManager);
            }, (ramAccounting, values, state) -> {
                float value = NumericUtils.sortableIntToFloat((int)((int)values.nextValue()));
                state.increment(value);
            });
            case 6 -> new SortedNumericDocValueAggregator<Variance>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                ramAccounting.addBytes((long)Variance.fixedSize());
                return (Variance)this.newState((RamAccounting)ramAccounting, (Version)version, (MemoryManager)memoryManager);
            }, (ramAccounting, values, state) -> {
                double value = NumericUtils.sortableLongToDouble((long)values.nextValue());
                state.increment(value);
            });
            default -> null;
        };
    }

    public static abstract class StdDevStateType<V extends Variance>
    extends DataType<V>
    implements Streamer<V>,
    FixedWidthType {
        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public Streamer<V> streamer() {
            return this;
        }

        @Override
        public V sanitizeValue(Object value) {
            return (V)((Variance)value);
        }

        @Override
        public int compare(V val1, V val2) {
            return ((Variance)val1).compareTo((Variance)val2);
        }

        @Override
        public int fixedSize() {
            return 192;
        }

        @Override
        public void writeValueTo(StreamOutput out, V v) throws IOException {
            ((Variance)v).writeTo(out);
        }

        @Override
        public long valueBytes(V value) {
            return this.fixedSize();
        }
    }
}

