/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.common.collections.Lists;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.impl.StandardDeviationAggregation;
import io.crate.execution.engine.aggregation.statistics.StandardDeviationPop;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.jetbrains.annotations.Nullable;

public class StandardDeviationPopAggregation
extends StandardDeviationAggregation<StandardDeviationPop> {
    public static final String NAME = "stddev_pop";
    private static final List<DataType<?>> SUPPORTED_TYPES;

    public static void register(Functions.Builder builder) {
        for (DataType<?> supportedType : SUPPORTED_TYPES) {
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), StandardDeviationPopAggregation::new);
        }
    }

    public StandardDeviationPopAggregation(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public DataType<?> partialType() {
        return new StdDevPopStateType();
    }

    @Override
    @Nullable
    public StandardDeviationPop newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)StandardDeviationPop.fixedSize());
        return new StandardDeviationPop();
    }

    static {
        DataTypes.register(8192, streamInput -> StdDevPopStateType.INSTANCE);
        SUPPORTED_TYPES = Lists.concat(DataTypes.NUMERIC_PRIMITIVE_TYPES, (Object)DataTypes.TIMESTAMPZ);
    }

    public static class StdDevPopStateType
    extends StandardDeviationAggregation.StdDevStateType<StandardDeviationPop> {
        public static final StdDevPopStateType INSTANCE = new StdDevPopStateType();
        public static final int ID = 8192;

        @Override
        public int id() {
            return 8192;
        }

        @Override
        public String getName() {
            return "stddev_pop_state";
        }

        @Override
        public StandardDeviationPop readValueFrom(StreamInput in) throws IOException {
            return new StandardDeviationPop(in);
        }
    }
}

