/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.average;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.SortedNumericDocValueAggregator;
import io.crate.execution.engine.aggregation.impl.util.KahanSummationForDouble;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AverageAggregation
extends AggregationFunction<AverageState, Double> {
    public static final String[] NAMES = new String[]{"avg", "mean"};
    public static final String NAME = NAMES[0];
    static final List<DataType<?>> SUPPORTED_TYPES;
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final boolean isIntegral;

    public static void register(Functions.Builder builder) {
        for (String functionName : NAMES) {
            for (DataType<?> supportedType : SUPPORTED_TYPES) {
                builder.add(Signature.builder(functionName, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new AverageAggregation((Signature)signature, (BoundSignature)boundSignature, supportedType.id() != DataTypes.FLOAT.id() && supportedType.id() != DataTypes.DOUBLE.id()));
            }
        }
    }

    AverageAggregation(Signature signature, BoundSignature boundSignature, boolean isIntegral) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.isIntegral = isIntegral;
    }

    @Override
    public AverageState iterate(RamAccounting ramAccounting, MemoryManager memoryManager, AverageState state, Input<?> ... args) {
        Number value;
        if (state != null && (value = (Number)args[0].value()) != null) {
            state.addNumber(value.doubleValue(), this.isIntegral);
        }
        return state;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public AverageState removeFromAggregatedState(RamAccounting ramAccounting, AverageState previousAggState, Input<?>[] stateToRemove) {
        Number value;
        if (previousAggState != null && (value = (Number)stateToRemove[0].value()) != null) {
            previousAggState.removeNumber(value.doubleValue(), this.isIntegral);
        }
        return previousAggState;
    }

    @Override
    public AverageState reduce(RamAccounting ramAccounting, AverageState state1, AverageState state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        state1.reduce(state2, this.isIntegral);
        return state1;
    }

    @Override
    public Double terminatePartial(RamAccounting ramAccounting, AverageState state) {
        return state.value();
    }

    @Override
    @Nullable
    public AverageState newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)AverageStateType.INSTANCE.fixedSize());
        return new AverageState();
    }

    @Override
    public DataType<?> partialType() {
        return AverageStateType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        return switch (reference.valueType().id()) {
            case 2, 8, 9, 10 -> new SortedNumericDocValueAggregator<AverageState>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                ramAccounting.addBytes((long)AverageStateType.INSTANCE.fixedSize());
                return new AverageState();
            }, (ramAccounting, values, state) -> state.addNumber(values.nextValue(), true));
            case 7 -> new SortedNumericDocValueAggregator<AverageState>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                ramAccounting.addBytes((long)AverageStateType.INSTANCE.fixedSize());
                return new AverageState();
            }, (ramAccounting, values, state) -> {
                float value = NumericUtils.sortableIntToFloat((int)((int)values.nextValue()));
                state.addNumber(value, false);
            });
            case 6 -> new SortedNumericDocValueAggregator<AverageState>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> {
                ramAccounting.addBytes((long)AverageStateType.INSTANCE.fixedSize());
                return new AverageState();
            }, (ramAccounting, values, state) -> {
                double value = NumericUtils.sortableLongToDouble((long)values.nextValue());
                state.addNumber(value, false);
            });
            default -> null;
        };
    }

    static {
        DataTypes.register(1024, streamInput -> AverageStateType.INSTANCE);
        SUPPORTED_TYPES = Lists.concat(DataTypes.NUMERIC_PRIMITIVE_TYPES, (Object)DataTypes.TIMESTAMPZ);
    }

    public static class AverageState
    implements Comparable<AverageState> {
        private double sum = 0.0;
        private long count = 0L;
        private final KahanSummationForDouble kahanSummationForDouble = new KahanSummationForDouble();

        public Double value() {
            if (this.count > 0L) {
                return this.sum / (double)this.count;
            }
            return null;
        }

        public void addNumber(double number, boolean isIntegral) {
            this.sum = isIntegral ? this.sum + number : this.kahanSummationForDouble.sum(this.sum, number);
            ++this.count;
        }

        public void removeNumber(double number, boolean isIntegral) {
            this.sum = isIntegral ? this.sum - number : this.kahanSummationForDouble.sum(this.sum, -number);
            --this.count;
        }

        public void reduce(@NotNull AverageState other, boolean isIntegral) {
            this.count += other.count;
            this.sum = isIntegral ? this.sum + other.sum : this.kahanSummationForDouble.sum(this.sum, other.sum);
        }

        @Override
        public int compareTo(AverageState o) {
            if (o == null) {
                return 1;
            }
            int compare = Double.compare(this.sum, o.sum);
            if (compare == 0) {
                return Long.compare(this.count, o.count);
            }
            return compare;
        }

        public String toString() {
            return "sum: " + this.sum + " count: " + this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AverageState that = (AverageState)o;
            return Objects.equals(that.value(), this.value());
        }

        public int hashCode() {
            return Objects.hash(this.value());
        }
    }

    public static class AverageStateType
    extends DataType<AverageState>
    implements FixedWidthType,
    Streamer<AverageState> {
        public static final int ID = 1024;
        private static final AverageStateType INSTANCE = new AverageStateType();
        private static final int AVERAGE_STATE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(AverageState.class);

        @Override
        public int id() {
            return 1024;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "average_state";
        }

        @Override
        public Streamer<AverageState> streamer() {
            return this;
        }

        @Override
        public AverageState sanitizeValue(Object value) {
            return (AverageState)value;
        }

        @Override
        public int compare(AverageState val1, AverageState val2) {
            if (val1 == null) {
                return -1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public AverageState readValueFrom(StreamInput in) throws IOException {
            AverageState averageState = new AverageState();
            averageState.sum = in.readDouble();
            averageState.count = in.readVLong();
            return averageState;
        }

        @Override
        public void writeValueTo(StreamOutput out, AverageState v) throws IOException {
            out.writeDouble(v.sum);
            out.writeVLong(v.count);
        }

        @Override
        public int fixedSize() {
            return AVERAGE_STATE_SIZE;
        }

        @Override
        public long valueBytes(AverageState value) {
            return this.fixedSize();
        }
    }
}

