/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.average;

import io.crate.Streamer;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.impl.average.AverageAggregation;
import io.crate.execution.engine.aggregation.impl.util.OverflowAwareMutableLong;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.joda.time.PeriodType;

public class IntervalAverageAggregation
extends AggregationFunction<IntervalAverageState, Period> {
    private final Signature signature;
    private final BoundSignature boundSignature;

    public static void register(Functions.Builder builder) {
        for (String functionName : AverageAggregation.NAMES) {
            builder.add(Signature.builder(functionName, FunctionType.AGGREGATE).argumentTypes(DataTypes.INTERVAL.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), IntervalAverageAggregation::new);
        }
    }

    IntervalAverageAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public IntervalAverageState iterate(RamAccounting ramAccounting, MemoryManager memoryManager, IntervalAverageState state, Input<?> ... args) {
        Period value;
        if (state != null && (value = (Period)args[0].value()) != null) {
            state.addPeriod(value);
        }
        return state;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public IntervalAverageState removeFromAggregatedState(RamAccounting ramAccounting, IntervalAverageState previousAggState, Input<?>[] stateToRemove) {
        Period value;
        if (previousAggState != null && (value = (Period)stateToRemove[0].value()) != null) {
            previousAggState.removePeriod(value);
        }
        return previousAggState;
    }

    @Override
    public IntervalAverageState reduce(RamAccounting ramAccounting, IntervalAverageState state1, IntervalAverageState state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        state1.reduce(state2);
        return state1;
    }

    @Override
    public Period terminatePartial(RamAccounting ramAccounting, IntervalAverageState state) {
        return state.value();
    }

    @Override
    @Nullable
    public IntervalAverageState newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)IntervalAverageStateType.INSTANCE.fixedSize());
        return new IntervalAverageState();
    }

    @Override
    public DataType<?> partialType() {
        return IntervalAverageStateType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    static {
        DataTypes.register(1028, in -> IntervalAverageStateType.INSTANCE);
    }

    public static class IntervalAverageState
    implements Comparable<IntervalAverageState> {
        private long[] sum = new long[8];
        private long count = 0L;

        public Period value() {
            if (this.count > 0L) {
                OverflowAwareMutableLong sumMillis = new OverflowAwareMutableLong(this.sum[7]);
                sumMillis.add(this.sum[6] * 1000L);
                sumMillis.add(this.sum[5] * 60000L);
                sumMillis.add(this.sum[4] * 3600000L);
                sumMillis.add(this.sum[3] * 86400000L);
                sumMillis.add(this.sum[2] * 604800000L);
                sumMillis.add(this.sum[1] * 86400000L * 30L);
                sumMillis.add(this.sum[0] * 86400000L * 365L);
                long avg = sumMillis.value().divideToIntegralValue(BigDecimal.valueOf(this.count)).longValue();
                return new Period(avg).normalizedStandard(PeriodType.yearMonthDayTime());
            }
            return null;
        }

        public void addPeriod(Period period) {
            this.sum[0] = this.sum[0] + (long)period.getYears();
            this.sum[1] = this.sum[1] + (long)period.getMonths();
            this.sum[2] = this.sum[2] + (long)period.getWeeks();
            this.sum[3] = this.sum[3] + (long)period.getDays();
            this.sum[4] = this.sum[4] + (long)period.getHours();
            this.sum[5] = this.sum[5] + (long)period.getMinutes();
            this.sum[6] = this.sum[6] + (long)period.getSeconds();
            this.sum[7] = this.sum[7] + (long)period.getMillis();
            ++this.count;
        }

        public void removePeriod(Period period) {
            this.sum[0] = this.sum[0] - (long)period.getYears();
            this.sum[1] = this.sum[1] - (long)period.getMonths();
            this.sum[2] = this.sum[2] - (long)period.getWeeks();
            this.sum[3] = this.sum[3] - (long)period.getDays();
            this.sum[4] = this.sum[4] - (long)period.getHours();
            this.sum[5] = this.sum[5] - (long)period.getMinutes();
            this.sum[6] = this.sum[6] - (long)period.getSeconds();
            this.sum[7] = this.sum[7] - (long)period.getMillis();
            --this.count;
        }

        public void reduce(@NotNull IntervalAverageState other) {
            this.count += other.count;
            for (int i = 0; i < this.sum.length; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + other.sum[i];
            }
        }

        @Override
        public int compareTo(IntervalAverageState o) {
            if (o == null) {
                return 1;
            }
            int compare = Arrays.compare(this.sum, o.sum);
            if (compare == 0) {
                return Long.compare(this.count, o.count);
            }
            return compare;
        }

        public String toString() {
            return "sum: " + Arrays.toString(this.sum) + " count: " + this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntervalAverageState that = (IntervalAverageState)o;
            return Objects.equals(that.value(), this.value());
        }

        public int hashCode() {
            return Objects.hash(this.value());
        }
    }

    public static class IntervalAverageStateType
    extends DataType<IntervalAverageState>
    implements FixedWidthType,
    Streamer<IntervalAverageState> {
        public static final int ID = 1028;
        private static final IntervalAverageStateType INSTANCE = new IntervalAverageStateType();
        private static final int AVERAGE_STATE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(IntervalAverageState.class);

        @Override
        public int id() {
            return 1028;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "interval_average_state";
        }

        @Override
        public Streamer<IntervalAverageState> streamer() {
            return this;
        }

        @Override
        public IntervalAverageState sanitizeValue(Object value) {
            return (IntervalAverageState)value;
        }

        @Override
        public int compare(IntervalAverageState val1, IntervalAverageState val2) {
            if (val1 == null) {
                return -1;
            }
            return val1.compareTo(val2);
        }

        @Override
        public IntervalAverageState readValueFrom(StreamInput in) throws IOException {
            IntervalAverageState averageState = new IntervalAverageState();
            averageState.sum = in.readLongArray();
            averageState.count = in.readVLong();
            return averageState;
        }

        @Override
        public void writeValueTo(StreamOutput out, IntervalAverageState v) throws IOException {
            out.writeLongArray(v.sum);
            out.writeVLong(v.count);
        }

        @Override
        public int fixedSize() {
            return AVERAGE_STATE_SIZE;
        }

        @Override
        public long valueBytes(IntervalAverageState value) {
            return this.fixedSize();
        }
    }
}

