/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.blob.v2.BlobShard;
import io.crate.common.collections.Lists;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.RowsTransformer;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.collect.collectors.BlobOrderedDocCollector;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.execution.jobs.NodeLimits;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.blob.BlobReferenceResolver;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import java.io.File;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public class BlobShardCollectorProvider
extends ShardCollectorProvider {
    private final BlobShard blobShard;
    private final InputFactory inputFactory;

    public BlobShardCollectorProvider(BlobShard blobShard, ClusterService clusterService, NodeLimits nodeJobsCounter, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, Client elasticsearchClient, Map<String, FileOutputFactory> fileOutputFactoryMap) {
        super(clusterService, circuitBreakerService, nodeJobsCounter, nodeCtx, threadPool, settings, elasticsearchClient, blobShard.indexShard(), new ShardRowContext(blobShard, clusterService), fileOutputFactoryMap);
        this.inputFactory = new InputFactory(nodeCtx);
        this.blobShard = blobShard;
    }

    @Override
    @Nullable
    protected BatchIterator<Row> getProjectionFusedIterator(RoutedCollectPhase normalizedPhase, CollectTask collectTask) {
        return null;
    }

    @Override
    protected BatchIterator<Row> getUnorderedIterator(RoutedCollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) {
        return InMemoryBatchIterator.of(this.getBlobRows(collectTask.txnCtx(), collectPhase, requiresScroll), (Object)SentinelRow.SENTINEL, (boolean)true);
    }

    private Iterable<Row> getBlobRows(TransactionContext txnCtx, RoutedCollectPhase collectPhase, boolean requiresRepeat) {
        Iterable<File> files = this.blobShard.blobContainer().getFiles();
        Iterable<Row> rows = RowsTransformer.toRowsIterable(txnCtx, this.inputFactory, BlobReferenceResolver.INSTANCE, collectPhase, files);
        if (requiresRepeat) {
            return Lists.of(rows);
        }
        return rows;
    }

    @Override
    public OrderedDocCollector getOrderedCollector(RoutedCollectPhase collectPhase, SharedShardContext sharedShardContext, CollectTask collectTask, boolean requiresRepeat) {
        return new BlobOrderedDocCollector(this.blobShard.indexShard().shardId(), this.getBlobRows(collectTask.txnCtx(), collectPhase, requiresRepeat));
    }
}

