/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.common.collections.Lists;
import io.crate.common.collections.RefCountedItem;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.GroupProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.GroupByMaps;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.execution.engine.collect.DocValuesAggregates;
import io.crate.execution.engine.collect.LuceneShardCollectorProvider;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.memory.MemoryManager;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.Version;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class DocValuesGroupByOptimizedIterator {
    DocValuesGroupByOptimizedIterator() {
    }

    @Nullable
    static BatchIterator<Row> tryOptimize(Functions functions, LuceneReferenceResolver referenceResolver, IndexShard indexShard, DocTableInfo table, LuceneQueryBuilder luceneQueryBuilder, DocInputFactory docInputFactory, RoutedCollectPhase collectPhase, CollectTask collectTask) {
        if (Symbols.hasColumn(collectPhase.toCollect(), SysColumns.SCORE) || collectPhase.where().hasColumn(SysColumns.SCORE)) {
            return null;
        }
        Collection<? extends Projection> shardProjections = Projections.shardProjections(collectPhase.projections());
        GroupProjection groupProjection = DocValuesGroupByOptimizedIterator.getSinglePartialGroupProjection(shardProjections);
        if (groupProjection == null) {
            return null;
        }
        ArrayList<Reference> columnKeyRefs = new ArrayList<Reference>(groupProjection.keys().size());
        for (Symbol key : groupProjection.keys()) {
            Reference docKeyRef = DocValuesGroupByOptimizedIterator.getKeyRef(collectPhase.toCollect(), key);
            if (docKeyRef == null) {
                return null;
            }
            Reference columnKeyRef = (Reference)DocReferences.inverseSourceLookup(docKeyRef);
            if (!columnKeyRef.hasDocValues()) {
                return null;
            }
            columnKeyRefs.add(columnKeyRef);
        }
        Version shardCreatedVersion = indexShard.getVersionCreated();
        List<DocValueAggregator> aggregators = DocValuesAggregates.createAggregators(functions, referenceResolver, groupProjection.values(), collectPhase.toCollect(), table, shardCreatedVersion);
        if (aggregators == null) {
            return null;
        }
        ShardId shardId = indexShard.shardId();
        SharedShardContext sharedShardContext = collectTask.sharedShardContexts().getOrCreateContext(shardId);
        RefCountedItem<? extends IndexSearcher> searcher = sharedShardContext.acquireSearcher("group-by-doc-value-aggregates: " + LuceneShardCollectorProvider.formatSource(collectPhase));
        collectTask.addSearcher(sharedShardContext.readerId(), searcher);
        IndexService indexService = sharedShardContext.indexService();
        InputFactory.Context<LuceneCollectorExpression<?>> docCtx = docInputFactory.getCtx(collectTask.txnCtx());
        String indexName = indexShard.shardId().getIndexName();
        ArrayList<LuceneCollectorExpression> keyExpressions = new ArrayList<LuceneCollectorExpression>();
        for (Reference keyRef : columnKeyRefs) {
            keyExpressions.add((LuceneCollectorExpression)docCtx.add(keyRef));
        }
        LuceneQueryBuilder.Context queryContext = luceneQueryBuilder.convert(collectPhase.where(), collectTask.txnCtx(), indexName, indexService.indexAnalyzers(), table, shardCreatedVersion, indexService.cache(), collectTask::raiseIfKilled);
        if (columnKeyRefs.size() == 1) {
            return GroupByIterator.forSingleKey(aggregators, (IndexSearcher)searcher.item(), (Reference)columnKeyRefs.get(0), keyExpressions, collectTask.getRamAccounting(), collectTask.memoryManager(), collectTask.minNodeVersion(), queryContext.query(), new CollectorContext(sharedShardContext.readerId(), () -> StoredRowLookup.create(shardCreatedVersion, table, indexName)));
        }
        return GroupByIterator.forManyKeys(aggregators, (IndexSearcher)searcher.item(), columnKeyRefs, keyExpressions, collectTask.getRamAccounting(), collectTask.memoryManager(), collectTask.minNodeVersion(), queryContext.query(), new CollectorContext(sharedShardContext.readerId(), () -> StoredRowLookup.create(shardCreatedVersion, table, indexName)));
    }

    @Nullable
    private static Reference getKeyRef(List<Symbol> toCollect, Symbol key) {
        InputColumn inputCol;
        Symbol keyRef;
        if (key instanceof InputColumn && (keyRef = toCollect.get((inputCol = (InputColumn)key).index())) instanceof Reference) {
            Reference ref = (Reference)keyRef;
            return ref;
        }
        return null;
    }

    private static GroupProjection getSinglePartialGroupProjection(Collection<? extends Projection> shardProjections) {
        GroupProjection groupProjection;
        if (shardProjections.size() != 1) {
            return null;
        }
        Projection shardProjection = shardProjections.iterator().next();
        if (!(shardProjection instanceof GroupProjection) || (groupProjection = (GroupProjection)shardProjection).mode() == AggregateMode.ITER_FINAL) {
            return null;
        }
        return groupProjection;
    }

    static final class GroupByIterator {
        private GroupByIterator() {
        }

        @VisibleForTesting
        static BatchIterator<Row> forSingleKey(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, Reference keyReference, List<? extends LuceneCollectorExpression<?>> keyExpressions, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, Query query, CollectorContext collectorContext) {
            DataType<?> valueType = keyReference.valueType();
            return GroupByIterator.getIterator(aggregators, indexSearcher, keyExpressions, ramAccounting, memoryManager, minNodeVersion, GroupByMaps.accountForNewEntry(ramAccounting, valueType), expressions -> ((LuceneCollectorExpression)expressions.get(0)).value(), (key, cells) -> {
                cells[0] = key;
            }, query, collectorContext);
        }

        @VisibleForTesting
        static BatchIterator<Row> forManyKeys(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, List<Reference> keyColumnRefs, List<? extends LuceneCollectorExpression<?>> keyExpressions, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, Query query, CollectorContext collectorContext) {
            return GroupByIterator.getIterator(aggregators, indexSearcher, keyExpressions, ramAccounting, memoryManager, minNodeVersion, GroupByMaps.accountForNewEntry(ramAccounting, Lists.map(keyColumnRefs, Symbol::valueType)), expressions -> {
                ArrayList<Object> key = new ArrayList<Object>(keyColumnRefs.size());
                for (int i = 0; i < expressions.size(); ++i) {
                    key.add(((LuceneCollectorExpression)expressions.get(i)).value());
                }
                return key;
            }, (keys, cells) -> {
                for (int i = 0; i < keys.size(); ++i) {
                    cells[i] = keys.get(i);
                }
            }, query, collectorContext);
        }

        @VisibleForTesting
        static <K> BatchIterator<Row> getIterator(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, List<? extends LuceneCollectorExpression<?>> keyExpressions, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, BiConsumer<Map<K, Object[]>, K> accountForNewKeyEntry, Function<List<? extends LuceneCollectorExpression<?>>, K> keyExtractor, BiConsumer<K, Object[]> applyKeyToCells, Query query, CollectorContext collectorContext) {
            for (int i = 0; i < keyExpressions.size(); ++i) {
                keyExpressions.get(i).startCollect(collectorContext);
            }
            AtomicReference killed = new AtomicReference();
            return CollectingBatchIterator.newInstance(() -> killed.set(BatchIterator.CLOSED), killed::set, () -> {
                try {
                    return CompletableFuture.completedFuture(GroupByIterator.getRows(GroupByIterator.applyAggregatesGroupedByKey(aggregators, indexSearcher, keyExpressions, accountForNewKeyEntry, keyExtractor, ramAccounting, memoryManager, minNodeVersion, query, killed), keyExpressions.size(), applyKeyToCells, aggregators, ramAccounting));
                }
                catch (Throwable t) {
                    return CompletableFuture.failedFuture(t);
                }
            }, (boolean)true);
        }

        private static <K> Iterable<Row> getRows(Map<K, Object[]> groupedStates, int numberOfKeys, BiConsumer<K, Object[]> applyKeyToCells, List<DocValueAggregator> aggregators, RamAccounting ramAccounting) {
            return () -> {
                Object[] cells = new Object[numberOfKeys + aggregators.size()];
                RowN row = new RowN(cells);
                Function<Map.Entry, Row> mapper = entry -> {
                    Object key = entry.getKey();
                    applyKeyToCells.accept(key, cells);
                    Object[] states = (Object[])entry.getValue();
                    int c = numberOfKeys;
                    for (int i = 0; i < states.length; ++i) {
                        cells[c] = ((DocValueAggregator)aggregators.get(i)).partialResult(ramAccounting, states[i]);
                        ++c;
                    }
                    return row;
                };
                return groupedStates.entrySet().stream().map(mapper).iterator();
            };
        }

        private static <K> Map<K, Object[]> applyAggregatesGroupedByKey(List<DocValueAggregator> aggregators, IndexSearcher indexSearcher, List<? extends LuceneCollectorExpression<?>> keyExpressions, BiConsumer<Map<K, Object[]>, K> accountForNewKeyEntry, Function<List<? extends LuceneCollectorExpression<?>>, K> keyExtractor, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion, Query query, AtomicReference<Throwable> killed) throws IOException {
            HashMap<K, Object[]> statesByKey = new HashMap<K, Object[]>();
            Weight weight = indexSearcher.createWeight(indexSearcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            List leaves = indexSearcher.getTopReaderContext().leaves();
            for (LeafReaderContext leaf : leaves) {
                int i;
                GroupByIterator.raiseIfClosedOrKilled(killed);
                Scorer scorer = weight.scorer(leaf);
                if (scorer == null) continue;
                for (i = 0; i < keyExpressions.size(); ++i) {
                    keyExpressions.get(i).setNextReader(new ReaderContext(leaf));
                }
                for (i = 0; i < aggregators.size(); ++i) {
                    aggregators.get(i).loadDocValues(leaf);
                }
                DocIdSetIterator docs = scorer.iterator();
                Bits liveDocs = leaf.reader().getLiveDocs();
                int doc = docs.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    GroupByIterator.raiseIfClosedOrKilled(killed);
                    if (!GroupByIterator.docDeleted(liveDocs, doc)) {
                        for (int i2 = 0; i2 < keyExpressions.size(); ++i2) {
                            keyExpressions.get(i2).setNextDocId(doc);
                        }
                        K key = keyExtractor.apply(keyExpressions);
                        Object[] states = (Object[])statesByKey.get(key);
                        if (states == null) {
                            states = new Object[aggregators.size()];
                            for (i = 0; i < aggregators.size(); ++i) {
                                DocValueAggregator aggregator = aggregators.get(i);
                                states[i] = aggregator.initialState(ramAccounting, memoryManager, minNodeVersion);
                                aggregator.apply(ramAccounting, doc, states[i]);
                            }
                            accountForNewKeyEntry.accept(statesByKey, key);
                            statesByKey.put(key, states);
                        } else {
                            for (i = 0; i < aggregators.size(); ++i) {
                                aggregators.get(i).apply(ramAccounting, doc, states[i]);
                            }
                        }
                    }
                    doc = docs.nextDoc();
                }
            }
            return statesByKey;
        }

        private static boolean docDeleted(@Nullable Bits liveDocs, int doc) {
            return liveDocs != null && !liveDocs.get(doc);
        }

        private static void raiseIfClosedOrKilled(AtomicReference<Throwable> killed) {
            Throwable killedException = killed.get();
            if (killedException != null) {
                Exceptions.rethrowUnchecked((Throwable)killedException);
            }
        }
    }
}

