/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.common.CheckedFunction;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.CompositeBatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.data.SentinelRow;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.engine.collect.sources.ShardCollectSource;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.engine.pipeline.Projectors;
import io.crate.expression.reference.Doc;
import io.crate.expression.reference.doc.lucene.StoredRow;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.expression.symbol.Symbol;
import io.crate.memory.MemoryManager;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.PKAndVersion;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndicesService;
import org.jetbrains.annotations.Nullable;

public final class PKLookupOperation {
    private final IndicesService indicesService;
    private final ShardCollectSource shardCollectSource;

    public PKLookupOperation(IndicesService indicesService, ShardCollectSource shardCollectSource) {
        this.indicesService = indicesService;
        this.shardCollectSource = shardCollectSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T withDoc(IndexShard shard, String id, long version, VersionType versionType, long seqNo, long primaryTerm, DocTableInfo table, List<Symbol> columns, CheckedFunction<Doc, T, Exception> processDoc) {
        Term uidTerm = new Term("_id", Uid.encodeId(id));
        Engine.Get get = new Engine.Get(id, uidTerm).version(version).versionType(versionType).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm);
        try (Engine.GetResult getResult = shard.get(get);){
            VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = getResult.docIdAndVersion();
            if (docIdAndVersion == null) {
                Object object = processDoc.apply(null);
                return (T)object;
            }
            StoredRowLookup storedRowLookup = StoredRowLookup.create(shard.getVersionCreated(), table, shard.shardId().getIndexName(), columns, getResult.fromTranslog());
            ReaderContext context = new ReaderContext(docIdAndVersion.reader.getContext());
            StoredRow storedRow = storedRowLookup.getStoredRow(context, docIdAndVersion.docId);
            Doc doc = new Doc(docIdAndVersion.docId, shard.shardId().getIndexName(), id, docIdAndVersion.version, docIdAndVersion.seqNo, docIdAndVersion.primaryTerm, storedRow);
            Object object = processDoc.apply((Object)doc);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Throwable t) {
            throw Exceptions.toRuntimeException((Throwable)t);
        }
    }

    public BatchIterator<Row> lookup(UUID jobId, TransactionContext txnCtx, Supplier<RamAccounting> ramAccountingSupplier, Supplier<MemoryManager> memoryManagerSupplier, boolean ignoreMissing, Map<ShardId, SequencedSet<PKAndVersion>> idsByShard, Collection<? extends Projection> projections, boolean requiresScroll, Function<Doc, Row> resultToRow, Function<RelationName, DocTableInfo> getTableInfo, List<Symbol> columns) {
        ArrayList<Object> iterators = new ArrayList<Object>(idsByShard.size());
        for (Map.Entry<ShardId, SequencedSet<PKAndVersion>> idsByShardEntry : idsByShard.entrySet()) {
            ProjectorFactory projectorFactory;
            ShardId shardId = idsByShardEntry.getKey();
            IndexService indexService = this.indicesService.indexService(shardId.getIndex());
            if (indexService == null) {
                if (ignoreMissing) continue;
                throw new IndexNotFoundException(shardId.getIndex());
            }
            IndexShard shard = indexService.getShardOrNull(shardId.id());
            if (shard == null) {
                if (ignoreMissing) continue;
                throw new ShardNotFoundException(shardId);
            }
            String indexName = shardId.getIndexName();
            RelationName relationName = RelationName.fromIndexName(indexName);
            DocTableInfo table = getTableInfo.apply(relationName);
            assert (table != null) : "Table for index " + indexName + " must not be null";
            Stream<Row> rowStream = idsByShardEntry.getValue().stream().map(pkAndVersion -> (Row)PKLookupOperation.withDoc(shard, pkAndVersion.id(), pkAndVersion.version(), VersionType.EXTERNAL, pkAndVersion.seqNo(), pkAndVersion.primaryTerm(), table, columns, doc -> doc == null ? null : (Row)resultToRow.apply((Doc)doc))).filter(Objects::nonNull);
            if (projections.isEmpty()) {
                Iterable rowIterable = requiresScroll ? (Iterable)rowStream.map(row -> new RowN(row.materialize())).collect(Collectors.toList()) : rowStream::iterator;
                iterators.add(InMemoryBatchIterator.of((Iterable)rowIterable, (Object)SentinelRow.SENTINEL, (boolean)true));
                continue;
            }
            try {
                projectorFactory = this.shardCollectSource.getProjectorFactory(shardId);
            }
            catch (ShardNotFoundException e) {
                if (ignoreMissing) continue;
                throw e;
            }
            Projectors projectors = new Projectors(projections, jobId, txnCtx, ramAccountingSupplier.get(), memoryManagerSupplier.get(), projectorFactory);
            Iterable rowIterable = requiresScroll && !projectors.providesIndependentScroll() ? (Iterable)rowStream.map(row -> new RowN(row.materialize())).collect(Collectors.toList()) : rowStream::iterator;
            iterators.add(projectors.wrap((BatchIterator<Row>)InMemoryBatchIterator.of((Iterable)rowIterable, (Object)SentinelRow.SENTINEL, (boolean)true)));
        }
        return CompositeBatchIterator.seqComposite(iterators);
    }
}

