/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.CapturingRowConsumer;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.collect.collectors.RemoteCollector;
import io.crate.execution.engine.collect.collectors.ShardStateObserver;
import io.crate.execution.engine.collect.sources.ShardCollectorProviderFactory;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsNodeAction;
import io.crate.execution.jobs.transport.JobAction;
import io.crate.metadata.Routing;
import io.crate.planner.distribution.DistributionInfo;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class RemoteCollectorFactory {
    private static final Logger LOGGER = LogManager.getLogger(RemoteCollectorFactory.class);
    private static final int SENDER_PHASE_ID = 0;
    private final ClusterService clusterService;
    private final TasksService tasksService;
    private final Client elasticsearchClient;
    private final IndicesService indicesService;
    private final Executor searchTp;

    @Inject
    public RemoteCollectorFactory(ClusterService clusterService, TasksService tasksService, Node node, IndicesService indicesService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.tasksService = tasksService;
        this.elasticsearchClient = node.client();
        this.indicesService = indicesService;
        this.searchTp = threadPool.executor("search");
    }

    public CompletableFuture<BatchIterator<Row>> createCollector(ShardId shardId, RoutedCollectPhase collectPhase, CollectTask collectTask, ShardCollectorProviderFactory shardCollectorProviderFactory, boolean requiresScroll) {
        ShardStateObserver shardStateObserver = new ShardStateObserver(this.clusterService);
        return shardStateObserver.waitForActiveShard(shardId).thenCompose(primaryRouting -> this.localOrRemoteCollect((ShardRouting)primaryRouting, collectPhase, collectTask, shardCollectorProviderFactory, requiresScroll));
    }

    private CompletableFuture<BatchIterator<Row>> localOrRemoteCollect(ShardRouting primaryRouting, RoutedCollectPhase collectPhase, CollectTask collectTask, ShardCollectorProviderFactory collectorFactory, boolean requiresScroll) {
        String nodeId = primaryRouting.currentNodeId();
        String localNodeId = this.clusterService.localNode().getId();
        if (localNodeId.equalsIgnoreCase(nodeId)) {
            IndexShard indexShard = this.indicesService.indexServiceSafe(primaryRouting.index()).getShard(primaryRouting.shardId().id());
            ShardCollectorProvider collectorProvider = collectorFactory.create(indexShard);
            try {
                return collectorProvider.awaitShardSearchActive().thenApply(biFactory -> biFactory.getIterator(collectPhase, requiresScroll, collectTask));
            }
            catch (Exception e) {
                throw Exceptions.toRuntimeException((Throwable)e);
            }
        }
        return this.remoteBatchIterator(primaryRouting, collectPhase, collectTask, requiresScroll);
    }

    private CompletableFuture<BatchIterator<Row>> remoteBatchIterator(ShardRouting primaryRouting, RoutedCollectPhase collectPhase, CollectTask collectTask, boolean requiresScroll) {
        CapturingRowConsumer consumer = new CapturingRowConsumer(requiresScroll, collectTask.completionFuture());
        String remoteNodeId = primaryRouting.currentNodeId();
        String localNodeId = this.clusterService.localNode().getId();
        UUID childJobId = UUIDs.dirtyUUID();
        LOGGER.trace("Creating child remote collect with id={} for parent job={}", (Object)childJobId, (Object)collectPhase.jobId());
        RemoteCollector remoteCollector = new RemoteCollector(childJobId, collectTask.txnCtx().sessionSettings(), localNodeId, remoteNodeId, req -> this.elasticsearchClient.execute(JobAction.INSTANCE, req), req -> this.elasticsearchClient.execute(KillJobsNodeAction.INSTANCE, req), this.searchTp, this.tasksService, collectTask.getRamAccounting(), (RowConsumer)consumer, RemoteCollectorFactory.createRemoteCollectPhase(childJobId, collectPhase, primaryRouting.shardId(), remoteNodeId));
        collectTask.completionFuture().exceptionally(err -> {
            remoteCollector.kill((Throwable)err);
            consumer.capturedBatchIterator().whenComplete((bi, ignored) -> {
                if (bi != null) {
                    bi.kill(err);
                }
            });
            return null;
        });
        remoteCollector.doCollect();
        return consumer.capturedBatchIterator();
    }

    private static RoutedCollectPhase createRemoteCollectPhase(UUID childJobId, RoutedCollectPhase collectPhase, ShardId shardId, String nodeId) {
        Routing routing = new Routing(Map.of(nodeId, Map.of(shardId.getIndexName(), IntArrayList.from((int[])new int[]{shardId.id()}))));
        return new RoutedCollectPhase(childJobId, 0, collectPhase.name(), routing, collectPhase.maxRowGranularity(), collectPhase.toCollect(), Projections.shardProjections(collectPhase.projections()), collectPhase.where(), DistributionInfo.DEFAULT_BROADCAST);
    }
}

