/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.analyze.OrderBy;
import io.crate.expression.reference.doc.lucene.NullSentinelValues;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public class OptimizeQueryForSearchAfter
implements Function<FieldDoc, Query> {
    private final OrderBy orderBy;
    private final Object[] missingValues;

    public OptimizeQueryForSearchAfter(OrderBy orderBy) {
        this.orderBy = orderBy;
        this.missingValues = new Object[orderBy.orderBySymbols().size()];
        for (int i = 0; i < orderBy.orderBySymbols().size(); ++i) {
            this.missingValues[i] = NullSentinelValues.nullSentinelForScoreDoc(orderBy, i);
        }
    }

    @Override
    public Query apply(FieldDoc lastCollected) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (int i = 0; i < this.orderBy.orderBySymbols().size(); ++i) {
            Query orderQuery;
            EqQuery<?> eqQuery;
            Symbol order = this.orderBy.orderBySymbols().get(i);
            Object value = lastCollected.fields[i];
            if (!(order instanceof Reference)) continue;
            Reference ref = (Reference)order;
            ColumnIdent columnIdent = ref.column();
            if (columnIdent.isSystemColumn()) {
                return null;
            }
            StorageSupport<?> storageSupport = ref.valueType().storageSupport();
            EqQuery<?> eqQuery2 = eqQuery = storageSupport == null ? null : storageSupport.eqQuery();
            if (eqQuery == null) {
                return null;
            }
            boolean nullsFirst = this.orderBy.nullsFirst()[i];
            Object object = value = value == null || value.equals(this.missingValues[i]) ? null : value;
            if (nullsFirst && value == null) continue;
            String storageIdent = ref.storageIdent();
            if (nullsFirst) {
                BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
                booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                Query rangeQuery = this.orderBy.reverseFlags()[i] ? eqQuery.rangeQuery(storageIdent, null, value, false, true, ref.hasDocValues(), ref.indexType() != IndexType.NONE) : eqQuery.rangeQuery(storageIdent, value, null, true, false, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
                if (rangeQuery == null) {
                    return null;
                }
                booleanQuery.add(rangeQuery, BooleanClause.Occur.MUST_NOT);
                orderQuery = booleanQuery.build();
            } else {
                orderQuery = this.orderBy.reverseFlags()[i] ? eqQuery.rangeQuery(storageIdent, value, null, false, false, ref.hasDocValues(), ref.indexType() != IndexType.NONE) : eqQuery.rangeQuery(storageIdent, null, value, false, false, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
                if (orderQuery == null) {
                    return null;
                }
            }
            queryBuilder.add(orderQuery, BooleanClause.Occur.MUST);
        }
        BooleanQuery query = queryBuilder.build();
        if (query.clauses().isEmpty()) {
            return null;
        }
        return query;
    }
}

