/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.common.concurrent.Killable;
import io.crate.data.Row;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import java.util.Collections;
import java.util.function.Supplier;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.NotNull;

public abstract class OrderedDocCollector
implements Supplier<KeyIterable<ShardId, Row>>,
AutoCloseable,
Killable {
    private final ShardId shardId;
    protected final KeyIterable<ShardId, Row> empty;
    boolean exhausted = false;

    public static OrderedDocCollector empty(ShardId shardId) {
        return new OrderedDocCollector(shardId){

            @Override
            protected KeyIterable<ShardId, Row> collect() {
                return this.empty;
            }

            @Override
            public boolean exhausted() {
                return true;
            }
        };
    }

    OrderedDocCollector(ShardId shardId) {
        this.shardId = shardId;
        this.empty = new KeyIterable(shardId, Collections.emptyList());
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void close() {
    }

    public void kill(@NotNull Throwable t) {
    }

    @Override
    public KeyIterable<ShardId, Row> get() {
        return this.collect();
    }

    protected abstract KeyIterable<ShardId, Row> collect();

    public boolean exhausted() {
        return this.exhausted;
    }

    public KeyIterable<ShardId, Row> empty() {
        return this.empty;
    }
}

