/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.common.StringUtils;
import io.crate.common.Suppliers;
import io.crate.execution.engine.collect.files.SummitsContext;
import io.crate.types.DataTypes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.locationtech.spatial4j.shape.Point;

public class SummitsIterable
implements Iterable<SummitsContext> {
    private final Supplier<List<SummitsContext>> summitsSupplierCache = Suppliers.memoizeWithExpiration(this::fetchSummits, (long)4L, (TimeUnit)TimeUnit.MINUTES);

    private List<SummitsContext> fetchSummits() {
        ArrayList<SummitsContext> summits = new ArrayList<SummitsContext>();
        try (InputStream input = SummitsIterable.class.getResourceAsStream("/config/names.txt");
             BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                List parts = StringUtils.splitToList((char)'\t', (String)line);
                summits.add(new SummitsContext((String)parts.get(0), SummitsIterable.tryParse((String)parts.get(1)), SummitsIterable.tryParse((String)parts.get(2)), SummitsIterable.safeParseCoordinates((String)parts.get(3)), (String)parts.get(4), (String)parts.get(5), (String)parts.get(6), (String)parts.get(7), SummitsIterable.tryParse((String)parts.get(8))));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot populate the sys.summits table", e);
        }
        return summits;
    }

    private static Integer tryParse(String string) {
        Long result = null;
        try {
            result = Long.parseLong(string, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (result != (long)result.intValue()) {
            return null;
        }
        return result.intValue();
    }

    @Nullable
    private static Point safeParseCoordinates(String value) {
        return value.isEmpty() ? null : DataTypes.GEO_POINT.implicitCast(value);
    }

    @Override
    public Iterator<SummitsContext> iterator() {
        return this.summitsSupplierCache.get().iterator();
    }
}

