/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.common.unit.TimeValue;
import io.crate.data.BatchIterator;
import io.crate.data.Paging;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.JobKilledException;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.distribution.DistributedResultRequest;
import io.crate.execution.engine.distribution.DistributedResultResponse;
import io.crate.execution.engine.distribution.MultiBucketBuilder;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.distribution.TransportDistributedResultAction;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.NodeRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class DistributingConsumer
implements RowConsumer {
    private static final Logger LOGGER = LogManager.getLogger(DistributingConsumer.class);
    private final Executor responseExecutor;
    private final UUID jobId;
    private final int targetPhaseId;
    private final byte inputId;
    private final int bucketIdx;
    private final ActionExecutor<NodeRequest<DistributedResultRequest>, DistributedResultResponse> distributedResultAction;
    private final int pageSize;
    private final StreamBucket[] buckets;
    private final List<Downstream> downstreams;
    private final boolean traceEnabled;
    private final CompletableFuture<Void> completionFuture;
    private final ThreadPool threadPool;
    @VisibleForTesting
    final long maxBytes;
    @VisibleForTesting
    final MultiBucketBuilder multiBucketBuilder;
    private volatile Throwable failure;
    private final ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction;
    private final String localNodeId;

    public DistributingConsumer(Executor responseExecutor, UUID jobId, MultiBucketBuilder multiBucketBuilder, int targetPhaseId, byte inputId, int bucketIdx, Collection<String> downstreamNodeIds, ActionExecutor<NodeRequest<DistributedResultRequest>, DistributedResultResponse> distributedResultAction, ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction, String localNodeId, int pageSize, ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.traceEnabled = LOGGER.isTraceEnabled();
        this.responseExecutor = responseExecutor;
        this.jobId = jobId;
        this.multiBucketBuilder = multiBucketBuilder;
        this.targetPhaseId = targetPhaseId;
        this.inputId = inputId;
        this.bucketIdx = bucketIdx;
        this.distributedResultAction = distributedResultAction;
        this.killNodeAction = killNodeAction;
        this.localNodeId = localNodeId;
        this.pageSize = pageSize;
        this.buckets = new StreamBucket[downstreamNodeIds.size()];
        this.completionFuture = new CompletableFuture();
        this.downstreams = new ArrayList<Downstream>(downstreamNodeIds.size());
        for (String downstreamNodeId : downstreamNodeIds) {
            this.downstreams.add(new Downstream(downstreamNodeId));
        }
        assert (this.downstreams.size() > 0) : "Must always have at least one downstream";
        this.maxBytes = Math.max(Paging.MAX_PAGE_BYTES / (long)this.downstreams.size(), 0x200000L);
    }

    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            this.consumeIt(iterator);
        } else {
            this.completionFuture.completeExceptionally(failure);
            this.forwardFailure(null, failure);
        }
    }

    public CompletableFuture<?> completionFuture() {
        return this.completionFuture;
    }

    private void consumeIt(BatchIterator<Row> it) {
        try {
            while (it.moveNext()) {
                this.multiBucketBuilder.add((Row)it.currentElement());
                if (this.multiBucketBuilder.size() < this.pageSize && this.multiBucketBuilder.ramBytesUsed() < this.maxBytes) continue;
                this.forwardResults(it, false);
                return;
            }
            if (it.allLoaded()) {
                this.forwardResults(it, true);
            } else {
                it.loadNextBatch().whenComplete((object, t) -> {
                    if (t == null) {
                        this.consumeIt(it);
                    } else {
                        this.forwardFailure(it, (Throwable)t);
                    }
                });
            }
        }
        catch (Throwable t2) {
            this.forwardFailure(it, t2);
        }
    }

    private void forwardFailure(@Nullable BatchIterator<Row> it, Throwable f) {
        Throwable failure = SQLExceptions.unwrap(f);
        AtomicInteger numActiveRequests = new AtomicInteger(this.downstreams.size());
        DistributedResultRequest.Builder builder = new DistributedResultRequest.Builder(this.jobId, this.targetPhaseId, this.inputId, this.bucketIdx, failure, false);
        for (int i = 0; i < this.downstreams.size(); ++i) {
            Downstream downstream = this.downstreams.get(i);
            if (!downstream.needsMoreData) {
                this.countdownAndMaybeCloseIt(numActiveRequests, it);
                continue;
            }
            if (this.traceEnabled) {
                LOGGER.trace("forwardFailure targetNode={} jobId={} targetPhase={}/{} bucket={} failure={}", (Object)downstream.nodeId, (Object)this.jobId, (Object)this.targetPhaseId, (Object)this.inputId, (Object)this.bucketIdx, (Object)failure);
            }
            NodeRequest<DistributedResultRequest> request = builder.build(downstream.nodeId);
            ResponseHandler responseHandler = new ResponseHandler(downstream, request, it, numActiveRequests, true);
            this.distributedResultAction.execute(request).whenComplete((BiConsumer)responseHandler);
        }
    }

    private void countdownAndMaybeCloseIt(AtomicInteger numActiveRequests, @Nullable BatchIterator<?> it) {
        if (numActiveRequests.decrementAndGet() == 0 && it != null) {
            it.close();
            this.completionFuture.complete(null);
        }
    }

    private void forwardResults(BatchIterator<Row> it, boolean isLast) {
        this.multiBucketBuilder.build(this.buckets);
        AtomicInteger numActiveRequests = new AtomicInteger(this.downstreams.size());
        for (int i = 0; i < this.downstreams.size(); ++i) {
            Downstream downstream = this.downstreams.get(i);
            if (!downstream.needsMoreData) {
                this.countdownAndMaybeContinue(it, numActiveRequests, true);
                continue;
            }
            if (this.traceEnabled) {
                LOGGER.trace("forwardResults targetNode={} jobId={} targetPhase={}/{} bucket={} isLast={}", (Object)downstream.nodeId, (Object)this.jobId, (Object)this.targetPhaseId, (Object)this.inputId, (Object)this.bucketIdx, (Object)isLast);
            }
            NodeRequest<DistributedResultRequest> request = DistributedResultRequest.of(downstream.nodeId, this.jobId, this.targetPhaseId, this.inputId, this.bucketIdx, this.buckets[i], isLast);
            ResponseHandler responseHandler = new ResponseHandler(downstream, request, it, numActiveRequests, false);
            this.distributedResultAction.execute(request).whenComplete((BiConsumer)responseHandler);
        }
    }

    private void countdownAndMaybeContinue(BatchIterator<Row> it, AtomicInteger numActiveRequests, boolean sameExecutor) {
        if (numActiveRequests.decrementAndGet() == 0) {
            if (this.downstreams.stream().anyMatch(Downstream::needsMoreData)) {
                if (this.failure == null) {
                    if (sameExecutor) {
                        this.consumeIt(it);
                    } else {
                        try {
                            this.responseExecutor.execute(() -> this.consumeIt(it));
                        }
                        catch (EsRejectedExecutionException e) {
                            this.failure = e;
                            this.forwardFailure(it, this.failure);
                        }
                    }
                } else {
                    this.forwardFailure(it, this.failure);
                }
            } else {
                it.close();
                this.completionFuture.complete(null);
            }
        }
    }

    public String toString() {
        return "DistributingConsumer{jobId=" + String.valueOf(this.jobId) + ", targetPhaseId=" + this.targetPhaseId + ", inputId=" + this.inputId + ", bucketIdx=" + this.bucketIdx + ", downstreams=" + String.valueOf(this.downstreams) + ", failure=" + String.valueOf(this.failure) + "}";
    }

    private static class Downstream {
        private final String nodeId;
        private boolean needsMoreData = true;

        Downstream(String nodeId) {
            this.nodeId = nodeId;
        }

        boolean needsMoreData() {
            return this.needsMoreData;
        }

        public String toString() {
            return "Downstream{" + this.nodeId + "', needsMoreData=" + this.needsMoreData + "}";
        }
    }

    class ResponseHandler
    implements BiConsumer<DistributedResultResponse, Throwable> {
        private final Downstream downstream;
        private final NodeRequest<DistributedResultRequest> request;
        private final BatchIterator<Row> it;
        private final AtomicInteger numActiveRequests;
        private final boolean isFailureReq;
        private final Iterator<TimeValue> retries;

        public ResponseHandler(Downstream downstream, NodeRequest<DistributedResultRequest> request, BatchIterator<Row> it, AtomicInteger numActiveRequests, boolean isFailureReq) {
            this.downstream = downstream;
            this.request = request;
            this.it = it;
            this.numActiveRequests = numActiveRequests;
            this.isFailureReq = isFailureReq;
            this.retries = BackoffPolicy.exponentialBackoff().iterator();
        }

        @Override
        public void accept(DistributedResultResponse resp, Throwable err) {
            if (err == null) {
                if (this.isFailureReq) {
                    this.downstream.needsMoreData = false;
                    DistributingConsumer.this.countdownAndMaybeCloseIt(this.numActiveRequests, this.it);
                } else {
                    this.downstream.needsMoreData = resp.needMore();
                    DistributingConsumer.this.countdownAndMaybeContinue(this.it, this.numActiveRequests, false);
                }
                return;
            }
            err = SQLExceptions.unwrap(err);
            LOGGER.trace("Failure from downstream while sending result. job={} targetNode={} failure={}", (Object)DistributingConsumer.this.jobId, (Object)this.downstream.nodeId, (Object)err);
            if (err instanceof ConnectTransportException && this.retries.hasNext()) {
                LOGGER.trace("Retry sending result", err);
                TimeValue delay = this.retries.next();
                try {
                    Scheduler.Cancellable cancellable = DistributingConsumer.this.threadPool.scheduleUnlessShuttingDown(delay, "same", () -> {
                        try {
                            DistributingConsumer.this.responseExecutor.execute(() -> DistributingConsumer.this.distributedResultAction.execute(this.request).whenComplete((BiConsumer)this));
                        }
                        catch (RejectedExecutionException ex) {
                            this.handleFailure(ex);
                        }
                    });
                    if (cancellable == Scheduler.Cancellable.CANCELLED_NOOP) {
                        this.handleFailure(err);
                    }
                }
                catch (EsRejectedExecutionException ex) {
                    this.handleFailure(err);
                }
                return;
            }
            this.handleFailure(err);
        }

        private void handleFailure(Throwable err) {
            if (DistributingConsumer.this.failure == null || !(err instanceof JobKilledException)) {
                DistributingConsumer.this.failure = err;
            }
            this.downstream.needsMoreData = false;
            if (this.isFailureReq) {
                DistributingConsumer.this.countdownAndMaybeCloseIt(this.numActiveRequests, this.it);
            } else {
                if (!(err instanceof JobKilledException)) {
                    String reason = "An error was encountered: " + String.valueOf(err);
                    TransportDistributedResultAction.broadcastKill(DistributingConsumer.this.killNodeAction, DistributingConsumer.this.jobId, DistributingConsumer.this.localNodeId, reason);
                }
                this.it.close();
                DistributingConsumer.this.completionFuture.completeExceptionally(DistributingConsumer.this.failure);
            }
        }
    }
}

