/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.common.unit.TimeValue;
import io.crate.exceptions.JobKilledException;
import io.crate.exceptions.TaskMissing;
import io.crate.execution.engine.distribution.DistributedResultRequest;
import io.crate.execution.engine.distribution.DistributedResultResponse;
import io.crate.execution.jobs.DownstreamRXTask;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.PageResultListener;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsNodeAction;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.NodeRequest;
import io.crate.execution.support.Transports;
import io.crate.role.Role;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportDistributedResultAction
extends TransportAction<NodeRequest<DistributedResultRequest>, DistributedResultResponse> {
    private static final Logger LOGGER = LogManager.getLogger(TransportDistributedResultAction.class);
    private final Transports transports;
    private final TasksService tasksService;
    private final ScheduledExecutorService scheduler;
    private final ClusterService clusterService;
    private final ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction;
    private final Iterable<TimeValue> backoffPolicy;

    @Inject
    public TransportDistributedResultAction(Transports transports, TasksService tasksService, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, Node node) {
        this(transports, tasksService, threadPool, transportService, clusterService, req -> node.client().execute(KillJobsNodeAction.INSTANCE, req), BackoffPolicy.exponentialBackoff());
    }

    @VisibleForTesting
    TransportDistributedResultAction(Transports transports, TasksService tasksService, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction, Iterable<TimeValue> backoffPolicy) {
        super("internal:crate:sql/node/merge");
        this.transports = transports;
        this.tasksService = tasksService;
        this.scheduler = threadPool.scheduler();
        this.clusterService = clusterService;
        this.killNodeAction = killNodeAction;
        this.backoffPolicy = backoffPolicy;
        NodeAction nodeAction = this::nodeOperation;
        transportService.registerRequestHandler("internal:crate:sql/node/merge", "same", true, true, DistributedResultRequest::new, new NodeActionRequestHandler(nodeAction));
    }

    @Override
    protected void doExecute(NodeRequest<DistributedResultRequest> request, ActionListener<DistributedResultResponse> listener) {
        this.transports.sendRequest("internal:crate:sql/node/merge", request.nodeId(), request.innerRequest(), listener, new ActionListenerResponseHandler<DistributedResultResponse>("internal:crate:sql/node/merge", listener, DistributedResultResponse::new));
    }

    CompletableFuture<DistributedResultResponse> nodeOperation(DistributedResultRequest request) {
        return this.nodeOperation(request, null);
    }

    private CompletableFuture<DistributedResultResponse> nodeOperation(DistributedResultRequest request, @Nullable Iterator<TimeValue> retryDelay) {
        DownstreamRXTask rxTask;
        RootTask rootTask = this.tasksService.getTaskOrNull(request.jobId());
        if (rootTask == null) {
            if (this.tasksService.recentlyFailed(request.jobId())) {
                throw JobKilledException.of("Received result for job=" + String.valueOf(request.jobId()) + " but there is no context for this job due to a failure during the setup.");
            }
            return this.retryOrFailureResponse(request, retryDelay);
        }
        try {
            rxTask = (DownstreamRXTask)rootTask.getTask(request.executionPhaseId());
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Found execution rootTask for %d but it's not a downstream rootTask", request.executionPhaseId()), e);
        }
        PageBucketReceiver pageBucketReceiver = rxTask.getBucketReceiver(request.executionPhaseInputId());
        if (pageBucketReceiver == null) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Couldn't find BucketReceiver for input %d", request.executionPhaseInputId()));
        }
        Throwable throwable = request.throwable();
        if (throwable == null) {
            SendResponsePageResultListener pageResultListener = new SendResponsePageResultListener();
            pageBucketReceiver.setBucket(request.bucketIdx(), request.readRows(pageBucketReceiver.streamers()), request.isLast(), pageResultListener);
            return pageResultListener.future;
        }
        pageBucketReceiver.kill(throwable);
        return CompletableFuture.completedFuture(new DistributedResultResponse(false));
    }

    private CompletableFuture<DistributedResultResponse> retryOrFailureResponse(DistributedResultRequest request, @Nullable Iterator<TimeValue> retryDelay) {
        if (retryDelay == null) {
            retryDelay = this.backoffPolicy.iterator();
        }
        if (retryDelay.hasNext()) {
            TimeValue delay = retryDelay.next();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("scheduling retry to start node operation for jobId: {} in {}ms", (Object)request.jobId(), (Object)delay.millis());
            }
            NodeOperationRunnable operationRunnable = new NodeOperationRunnable(request, retryDelay);
            this.scheduler.schedule(operationRunnable::run, delay.millis(), TimeUnit.MILLISECONDS);
            return operationRunnable;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Received a result for job={} but couldn't find a RootTask for it", (Object)request.jobId());
        }
        String reason = "Received data for job=" + String.valueOf(request.jobId()) + " but there is no job context present. This can happen due to bad network latency or if individual nodes are unresponsive due to high load";
        TransportDistributedResultAction.broadcastKill(this.killNodeAction, request.jobId(), this.clusterService.localNode().getId(), reason);
        return CompletableFuture.failedFuture(new TaskMissing(TaskMissing.Type.ROOT, request.jobId()));
    }

    public static void broadcastKill(ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction, UUID jobId, String localNodeId, String reason) {
        List<String> excludedNodeIds = Collections.singletonList(localNodeId);
        KillJobsNodeRequest killRequest = new KillJobsNodeRequest(excludedNodeIds, List.of(jobId), Role.CRATE_USER.name(), reason);
        killNodeAction.execute(killRequest).whenComplete((killResponse, t) -> {
            if (t != null) {
                LOGGER.debug("Could not kill " + String.valueOf(jobId), t);
            }
        });
    }

    private static class SendResponsePageResultListener
    implements PageResultListener {
        private final CompletableFuture<DistributedResultResponse> future = new CompletableFuture();

        private SendResponsePageResultListener() {
        }

        @Override
        public void needMore(boolean needMore) {
            LOGGER.trace("sending needMore response, need more? {}", (Object)needMore);
            this.future.complete(new DistributedResultResponse(needMore));
        }
    }

    private class NodeOperationRunnable
    extends CompletableFuture<DistributedResultResponse> {
        private final DistributedResultRequest request;
        private final Iterator<TimeValue> retryDelay;

        NodeOperationRunnable(DistributedResultRequest request, Iterator<TimeValue> retryDelay) {
            this.request = request;
            this.retryDelay = retryDelay;
        }

        public CompletableFuture<DistributedResultResponse> run() {
            try {
                return TransportDistributedResultAction.this.nodeOperation(this.request, this.retryDelay).whenComplete((r, f) -> {
                    if (f == null) {
                        this.complete(r);
                    } else {
                        this.completeExceptionally((Throwable)f);
                    }
                });
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
                return this;
            }
        }
    }
}

