/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.export;

import com.fasterxml.jackson.core.JsonGenerator;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.exceptions.SQLParseException;
import io.crate.exceptions.UnhandledServerException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.export.FileOutput;
import io.crate.execution.engine.export.FileOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class FileWriterCountCollector
implements Collector<Row, long[], Iterable<Row>> {
    private static final byte NEW_LINE = 10;
    private final Executor executor;
    private final Iterable<CollectExpression<Row, ?>> collectExpressions;
    private final List<Input<?>> inputs;
    private final URI uri;
    private final FileOutput fileOutput;
    private final WriterProjection.CompressionType compressionType;
    @Nullable
    private final List<String> outputNames;
    private final WriterProjection.OutputFormat outputFormat;
    private final RowWriter rowWriter;

    FileWriterCountCollector(Executor executor, String uriStr, @Nullable WriterProjection.CompressionType compressionType, @Nullable List<Input<?>> inputs, Iterable<CollectExpression<Row, ?>> collectExpressions, @Nullable List<String> outputNames, WriterProjection.OutputFormat outputFormat, Map<String, FileOutputFactory> fileOutputFactories, Settings withClauseOptions) {
        this.executor = executor;
        this.collectExpressions = collectExpressions;
        this.inputs = inputs;
        this.compressionType = compressionType;
        this.outputNames = outputNames;
        this.outputFormat = outputFormat;
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new SQLParseException(String.format(Locale.ENGLISH, "Invalid uri '%s'", uriStr), e);
        }
        String scheme = this.uri.getScheme();
        scheme = scheme == null ? "file" : scheme;
        FileOutputFactory fileOutputFactory = fileOutputFactories.get(scheme);
        if (fileOutputFactory == null) {
            throw new UnsupportedFeatureException(String.format(Locale.ENGLISH, "Unknown scheme '%s'", scheme));
        }
        this.fileOutput = fileOutputFactory.create(this.uri, withClauseOptions);
        this.rowWriter = this.initWriter();
    }

    private RowWriter initWriter() {
        try {
            if (this.outputFormat.equals((Object)WriterProjection.OutputFormat.JSON_ARRAY)) {
                return new ColumnRowWriter(this.fileOutput, this.fileOutput.acquireOutputStream(this.executor, this.compressionType), this.collectExpressions, this.inputs);
            }
            if (this.outputNames != null && this.outputFormat.equals((Object)WriterProjection.OutputFormat.JSON_OBJECT)) {
                return new ColumnRowObjectWriter(this.fileOutput, this.fileOutput.acquireOutputStream(this.executor, this.compressionType), this.collectExpressions, this.inputs, this.outputNames);
            }
            return new RawRowWriter(this.fileOutput, this.fileOutput.acquireOutputStream(this.executor, this.compressionType));
        }
        catch (IOException e) {
            throw new UnhandledServerException(String.format(Locale.ENGLISH, "Failed to open output: '%s'", e.getMessage()), e);
        }
    }

    private void closeWriterAndOutput() {
        try {
            if (this.rowWriter != null) {
                this.rowWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Supplier<long[]> supplier() {
        return () -> new long[1];
    }

    @Override
    public BiConsumer<long[], Row> accumulator() {
        return this::onNextRow;
    }

    private void onNextRow(long[] container, Row row) {
        this.rowWriter.write(row);
        container[0] = container[0] + 1L;
    }

    @Override
    public BinaryOperator<long[]> combiner() {
        return (state1, state2) -> {
            throw new UnsupportedOperationException("combine not supported");
        };
    }

    @Override
    public Function<long[], Iterable<Row>> finisher() {
        return container -> {
            this.closeWriterAndOutput();
            return Collections.singletonList(new Row1((Object)container[0]));
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @VisibleForTesting
    static XContentBuilder createJsonBuilder(OutputStream outputStream) throws IOException {
        XContentBuilder builder = XContentFactory.json((OutputStream)outputStream, (String)"");
        builder.generator().configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
        return builder;
    }

    static interface RowWriter {
        public void write(Row var1);

        public void close() throws IOException;
    }

    static class ColumnRowWriter
    implements RowWriter {
        private final Iterable<CollectExpression<Row, ?>> collectExpressions;
        private final FileOutput fileOutput;
        private final OutputStream outputStream;
        protected final List<Input<?>> inputs;
        protected final XContentBuilder builder;

        ColumnRowWriter(FileOutput fileOutput, OutputStream outputStream, Iterable<CollectExpression<Row, ?>> collectExpressions, List<Input<?>> inputs) throws IOException {
            this.fileOutput = fileOutput;
            this.outputStream = outputStream;
            this.collectExpressions = collectExpressions;
            this.inputs = inputs;
            this.builder = FileWriterCountCollector.createJsonBuilder(outputStream);
        }

        @Override
        public void write(Row row) {
            for (CollectExpression<Row, ?> collectExpression : this.collectExpressions) {
                collectExpression.setNextRow(row);
            }
            try {
                this.processInputs();
                this.builder.flush();
                this.outputStream.write(10);
            }
            catch (IOException e) {
                throw new UnhandledServerException("Failed to write row to output", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.builder.close();
            this.outputStream.close();
            this.fileOutput.close();
        }

        protected void processInputs() throws IOException {
            this.builder.startArray();
            for (Input<?> input : this.inputs) {
                this.builder.value(input.value());
            }
            this.builder.endArray();
        }
    }

    static class ColumnRowObjectWriter
    extends ColumnRowWriter {
        private final List<String> outputNames;

        public ColumnRowObjectWriter(FileOutput fileOutput, OutputStream outputStream, Iterable<CollectExpression<Row, ?>> collectExpressions, List<Input<?>> inputs, List<String> outputNames) throws IOException {
            super(fileOutput, outputStream, collectExpressions, inputs);
            this.outputNames = outputNames;
        }

        @Override
        protected void processInputs() throws IOException {
            try {
                this.builder.startObject();
                for (int i = 0; i < this.inputs.size(); ++i) {
                    this.builder.field(this.outputNames.get(i), ((Input)this.inputs.get(i)).value());
                }
                this.builder.endObject();
            }
            catch (IOException e) {
                throw new UnhandledServerException("Failed to write row to output", e);
            }
        }
    }

    static class RawRowWriter
    implements RowWriter {
        private final FileOutput fileOutput;
        private final OutputStream outputStream;

        RawRowWriter(FileOutput fileOutput, OutputStream outputStream) {
            this.fileOutput = fileOutput;
            this.outputStream = outputStream;
        }

        @Override
        public void write(Row row) {
            String value = (String)row.get(0);
            try {
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                this.outputStream.write(bytes);
                this.outputStream.write(10);
            }
            catch (IOException e) {
                throw new UnhandledServerException("Failed to write row to output", e);
            }
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
            this.fileOutput.close();
        }
    }
}

