/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntObjectMap;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.fetch.NodeFetchOperation;
import io.crate.execution.engine.fetch.NodeFetchRequest;
import io.crate.execution.engine.fetch.NodeFetchResponse;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportFetchNodeAction
extends TransportAction<NodeFetchRequest, NodeFetchResponse> {
    private final Transports transports;
    private final NodeFetchOperation nodeFetchOperation;

    @Inject
    public TransportFetchNodeAction(Settings settings, TransportService transportService, Transports transports, ThreadPool threadPool, JobsLogs jobsLogs, TasksService tasksService, CircuitBreakerService circuitBreakerService) {
        super("internal:crate:sql/node/fetch");
        this.transports = transports;
        this.nodeFetchOperation = new NodeFetchOperation((ThreadPoolExecutor)threadPool.executor("search"), EsExecutors.numberOfProcessors(settings), jobsLogs, tasksService, circuitBreakerService.getBreaker("query"));
        transportService.registerRequestHandler("internal:crate:sql/node/fetch", "search", true, false, NodeFetchRequest.FetchRequest::new, new NodeActionRequestHandler(this::nodeOperation));
    }

    @Override
    public void doExecute(NodeFetchRequest nodeFetchRequest, ActionListener<NodeFetchResponse> listener) {
        this.transports.sendRequest("internal:crate:sql/node/fetch", nodeFetchRequest.nodeId(), (NodeFetchRequest.FetchRequest)nodeFetchRequest.innerRequest(), listener, new ActionListenerResponseHandler<NodeFetchResponse>("internal:crate:sql/node/fetch", listener, nodeFetchRequest.createResponseReader()));
    }

    private CompletableFuture<NodeFetchResponse> nodeOperation(NodeFetchRequest.FetchRequest request) {
        CompletableFuture<? extends IntObjectMap<StreamBucket>> resultFuture = this.nodeFetchOperation.fetch(request.jobId(), request.fetchPhaseId(), request.toFetch(), request.isCloseContext());
        return resultFuture.thenApply(NodeFetchResponse::new);
    }
}

