/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.CompoundOrdering;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.sort.NullAwareComparator;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.consumer.OrderByPositionVisitor;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class OrderingByPosition {
    public static Comparator<Object[]> arrayOrdering(RoutedCollectPhase collectPhase) {
        OrderBy orderBy = collectPhase.orderBy();
        assert (orderBy != null) : "collectPhase must have an orderBy clause to generate an ordering";
        int[] positions = OrderByPositionVisitor.orderByPositions(orderBy.orderBySymbols(), collectPhase.toCollect());
        return OrderingByPosition.arrayOrdering(Symbols.typeView(collectPhase.toCollect()), positions, orderBy.reverseFlags(), orderBy.nullsFirst());
    }

    public static Comparator<Row> rowOrdering(List<? extends DataType<?>> rowTypes, PositionalOrderBy orderBy) {
        return OrderingByPosition.rowOrdering(rowTypes, orderBy.indices(), orderBy.reverseFlags(), orderBy.nullsFirst());
    }

    public static Comparator<Row> rowOrdering(OrderBy orderBy, List<Symbol> toCollect) {
        int[] positions = OrderByPositionVisitor.orderByPositions(orderBy.orderBySymbols(), toCollect);
        return OrderingByPosition.rowOrdering(Symbols.typeView(toCollect), positions, orderBy.reverseFlags(), orderBy.nullsFirst());
    }

    public static Comparator<Row> rowOrdering(List<? extends DataType<?>> rowTypes, int[] positions, boolean[] reverseFlags, boolean[] nullsFirst) {
        ArrayList<Comparator<Row>> comparators = new ArrayList<Comparator<Row>>(positions.length);
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i];
            Comparator<Row> rowOrdering = OrderingByPosition.rowOrdering(rowTypes.get(position), position, reverseFlags[i], nullsFirst[i]);
            comparators.add(rowOrdering);
        }
        return CompoundOrdering.of(comparators);
    }

    public static <T> Comparator<Row> rowOrdering(DataType<T> type, int position, boolean reverse, boolean nullsFirst) {
        return new NullAwareComparator<Row, Object>(row -> row.get(position), type, reverse, nullsFirst);
    }

    public static Comparator<Object[]> arrayOrdering(List<? extends DataType<?>> rowTypes, int[] positions, boolean[] reverse, boolean[] nullsFirst) {
        assert (rowTypes.size() >= positions.length) : "Must have a type for each order by position";
        if (positions.length == 1) {
            int position = positions[0];
            return OrderingByPosition.arrayOrdering(rowTypes.get(position), position, reverse[0], nullsFirst[0]);
        }
        ArrayList<Comparator<Object[]>> comparators = new ArrayList<Comparator<Object[]>>(positions.length);
        int positionLength = positions.length;
        for (int i = 0; i < positionLength; ++i) {
            int position = positions[i];
            comparators.add(OrderingByPosition.arrayOrdering(rowTypes.get(position), position, reverse[i], nullsFirst[i]));
        }
        return CompoundOrdering.of(comparators);
    }

    public static <T> Comparator<Object[]> arrayOrdering(DataType<T> type, int position, boolean reverse, boolean nullsFirst) {
        return new NullAwareComparator<Object[], Object>(cells -> cells[position], type, reverse, nullsFirst);
    }
}

