/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.common.collections.Iterables;
import io.crate.common.collections.Lists;
import io.crate.common.concurrent.CompletableFutures;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public final class Sort {
    public static <T> CompletableFuture<List<T>> parallelSort(List<T> list, Comparator<? super T> comparator, int minItemsPerThread, int numAvailableThreads, Executor executor) {
        int itemsPerThread = list.size() / Math.max(1, numAvailableThreads);
        if (numAvailableThreads <= 1 || itemsPerThread < minItemsPerThread) {
            list.sort(comparator);
            return CompletableFuture.completedFuture(list);
        }
        List partitions = Lists.partition(list, (int)itemsPerThread);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(partitions.size());
        for (List partition : partitions) {
            futures.add(CompletableFutures.supplyAsync(() -> {
                partition.sort(comparator);
                return partition;
            }, (Executor)executor));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(aVoid -> {
            ArrayList result = new ArrayList(list.size());
            ArrayList<List> parts = new ArrayList<List>(futures.size());
            for (int i = 0; i < futures.size(); ++i) {
                parts.add((List)((CompletableFuture)futures.get(i)).join());
            }
            Iterables.addAll(result, (Iterable)Iterables.mergeSorted(parts, (Comparator)comparator));
            return result;
        });
    }
}

