/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.window;

import io.crate.data.ArrayRow;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.expression.ExpressionsInput;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.memory.MemoryManager;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import java.util.List;
import java.util.function.LongConsumer;
import org.elasticsearch.Version;
import org.jetbrains.annotations.Nullable;

public class AggregateToWindowFunctionAdapter
implements WindowFunction {
    private final AggregationFunction aggregationFunction;
    private final ExpressionsInput<Row, Boolean> filter;
    private final RamAccounting ramAccounting;
    private final MemoryManager memoryManager;
    private final Version minNodeVersion;
    private Object accumulatedState;
    private int seenFrameLowerBound = -1;
    private int seenFrameUpperBound = -1;
    private Object resultForCurrentFrame;

    AggregateToWindowFunctionAdapter(AggregationFunction aggregationFunction, ExpressionsInput<Row, Boolean> filter, RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
        this.aggregationFunction = aggregationFunction.optimizeForExecutionAsWindowFunction();
        this.filter = filter;
        this.ramAccounting = ramAccounting;
        this.memoryManager = memoryManager;
        this.minNodeVersion = minNodeVersion;
        this.accumulatedState = this.aggregationFunction.newState(this.ramAccounting, minNodeVersion, memoryManager);
    }

    @Override
    public Signature signature() {
        return this.aggregationFunction.signature();
    }

    @Override
    public BoundSignature boundSignature() {
        return this.aggregationFunction.boundSignature();
    }

    @Override
    public Symbol normalizeSymbol(Function function, @Nullable TransactionContext txnCtx, NodeContext nodeCtx) {
        return this.aggregationFunction.normalizeSymbol(function, txnCtx, nodeCtx);
    }

    @Override
    public Object execute(LongConsumer allocateBytes, int idxInPartition, WindowFrameState frame, List<? extends CollectExpression<Row, ?>> expressions, @Nullable Boolean ignoreNulls, Input<?> ... args) {
        assert (ignoreNulls == null);
        if (idxInPartition == 0) {
            this.recomputeFunction(frame, expressions, args);
        } else if (WindowFrameState.isLowerBoundIncreasing(frame, this.seenFrameLowerBound)) {
            if (this.aggregationFunction.isRemovableCumulative()) {
                this.removeSeenRowsFromAccumulatedState(frame, expressions, args);
                this.resultForCurrentFrame = this.aggregationFunction.terminatePartial(this.ramAccounting, this.accumulatedState);
                if (frame.upperBoundExclusive() > this.seenFrameUpperBound) {
                    this.accumulateAndExecuteStartingWithIndex(this.seenFrameUpperBound, frame, expressions, args);
                }
                this.seenFrameLowerBound = frame.lowerBound();
                this.seenFrameUpperBound = frame.upperBoundExclusive();
            } else {
                this.recomputeFunction(frame, expressions, args);
            }
        } else if (frame.upperBoundExclusive() > this.seenFrameUpperBound) {
            this.executeAggregateForFrame(frame, expressions, args);
        }
        return this.resultForCurrentFrame;
    }

    private void removeSeenRowsFromAccumulatedState(WindowFrameState frame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
        ArrayRow row = new ArrayRow();
        for (int i = this.seenFrameLowerBound; i < frame.lowerBound(); ++i) {
            Object[] cells = frame.getRowInPartitionAtIndexOrNull(i);
            assert (cells != null) : "No row at idx=" + i + " in current partition=" + String.valueOf(frame);
            row.cells(cells);
            int expressionsSize = expressions.size();
            for (int j = 0; j < expressionsSize; ++j) {
                expressions.get(j).setNextRow((Row)row);
            }
            if (!this.filter.value((Row)row).booleanValue()) continue;
            this.accumulatedState = this.aggregationFunction.removeFromAggregatedState(this.ramAccounting, this.accumulatedState, args);
        }
    }

    private void recomputeFunction(WindowFrameState frame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... args) {
        this.accumulatedState = this.aggregationFunction.newState(this.ramAccounting, this.minNodeVersion, this.memoryManager);
        this.seenFrameUpperBound = -1;
        this.seenFrameLowerBound = -1;
        this.executeAggregateForFrame(frame, expressions, args);
    }

    private void executeAggregateForFrame(WindowFrameState frame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... inputs) {
        int unseenRowsInCurrentFrameStart = !WindowFrameState.isLowerBoundIncreasing(frame, this.seenFrameLowerBound) && this.seenFrameUpperBound > 0 ? this.seenFrameUpperBound : frame.lowerBound();
        this.accumulateAndExecuteStartingWithIndex(unseenRowsInCurrentFrameStart, frame, expressions, inputs);
    }

    private void accumulateAndExecuteStartingWithIndex(int indexInFrame, WindowFrameState frame, List<? extends CollectExpression<Row, ?>> expressions, Input<?> ... inputs) {
        ArrayRow row = new ArrayRow();
        for (int i = indexInFrame; i < frame.upperBoundExclusive(); ++i) {
            Object[] cells = frame.getRowInFrameAtIndexOrNull(i);
            assert (cells != null) : "No row at idx=" + i + " in current frame=" + String.valueOf(frame);
            row.cells(cells);
            int expressionsSize = expressions.size();
            for (int j = 0; j < expressionsSize; ++j) {
                expressions.get(j).setNextRow((Row)row);
            }
            if (!this.filter.value((Row)row).booleanValue()) continue;
            this.accumulatedState = this.aggregationFunction.iterate(this.ramAccounting, this.memoryManager, this.accumulatedState, inputs);
        }
        this.resultForCurrentFrame = this.aggregationFunction.terminatePartial(this.ramAccounting, this.accumulatedState);
        this.seenFrameLowerBound = frame.lowerBound();
        this.seenFrameUpperBound = frame.upperBoundExclusive();
    }
}

