/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.window;

import io.crate.collections.accountable.AccountableList;
import io.crate.common.collections.Iterables;
import io.crate.common.collections.Lists;
import io.crate.data.BatchIterator;
import io.crate.data.Buckets;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.sort.Sort;
import io.crate.execution.engine.window.ComputeFrameBoundary;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class WindowFunctionBatchIterator {
    private static final Logger LOGGER = LogManager.getLogger(WindowFunctionBatchIterator.class);

    public static BatchIterator<Row> of(BatchIterator<Row> source, LongConsumer allocateBytes, RowAccounting<Row> rowAccounting, ComputeFrameBoundary<Object[]> computeFrameStart, ComputeFrameBoundary<Object[]> computeFrameEnd, Comparator<Object[]> cmpPartitionBy, Comparator<Object[]> cmpOrderBy, int numCellsInSourceRow, IntSupplier numAvailableThreads, Executor executor, List<WindowFunction> windowFunctions, List<? extends CollectExpression<Row, ?>> argsExpressions, Boolean[] ignoreNulls, Input<?>[] ... args) {
        assert (windowFunctions.size() == args.length) : "arguments must be defined for each window function";
        assert (args.length == ignoreNulls.length) : "ignore-nulls option must be defined for each window function";
        Function<Row, Object[]> materialize = row -> {
            rowAccounting.accountForAndMaybeBreak(row);
            return WindowFunctionBatchIterator.materializeWithSpare(row, windowFunctions.size());
        };
        return CollectingBatchIterator.newInstance(source, src -> ((CompletableFuture)src.map(materialize).collect(Collectors.toCollection(() -> new AccountableList(allocateBytes))).thenCompose(rows -> WindowFunctionBatchIterator.sortAndComputeWindowFunctions(rows, allocateBytes, computeFrameStart, computeFrameEnd, cmpPartitionBy, cmpOrderBy, numCellsInSourceRow, numAvailableThreads, executor, windowFunctions, argsExpressions, ignoreNulls, args))).thenApply(rows -> Iterables.transform((Iterable)rows, Buckets.arrayToSharedRow()::apply)), (boolean)source.hasLazyResultSet());
    }

    private static Object[] materializeWithSpare(Row row, int numWindowFunctions) {
        Object[] cells = new Object[row.numColumns() + numWindowFunctions];
        for (int i = 0; i < row.numColumns(); ++i) {
            cells[i] = row.get(i);
        }
        return cells;
    }

    static CompletableFuture<Iterable<Object[]>> sortAndComputeWindowFunctions(List<Object[]> rows, LongConsumer allocateBytes, ComputeFrameBoundary<Object[]> computeFrameStart, ComputeFrameBoundary<Object[]> computeFrameEnd, @Nullable Comparator<Object[]> cmpPartitionBy, @Nullable Comparator<Object[]> cmpOrderBy, int numCellsInSourceRow, IntSupplier numAvailableThreads, Executor executor, List<WindowFunction> windowFunctions, List<? extends CollectExpression<Row, ?>> argsExpressions, Boolean[] ignoreNulls, Input<?>[] ... args) {
        Function<List, Iterable> computeWindowsFn = sortedRows -> WindowFunctionBatchIterator.computeWindowFunctions(sortedRows, allocateBytes, computeFrameStart, computeFrameEnd, cmpPartitionBy, numCellsInSourceRow, windowFunctions, argsExpressions, ignoreNulls, args);
        Comparator<Object[]> cmpPartitionThenOrderBy = WindowFunctionBatchIterator.joinCmp(cmpPartitionBy, cmpOrderBy);
        if (cmpPartitionThenOrderBy == null) {
            return CompletableFuture.completedFuture(computeWindowsFn.apply(rows));
        }
        int minItemsPerThread = 8192;
        return Sort.parallelSort(rows, cmpPartitionThenOrderBy, minItemsPerThread, numAvailableThreads.getAsInt(), executor).thenApply(computeWindowsFn);
    }

    private static Iterable<Object[]> computeWindowFunctions(final List<Object[]> sortedRows, final LongConsumer allocateBytes, final ComputeFrameBoundary<Object[]> computeFrameStart, final ComputeFrameBoundary<Object[]> computeFrameEnd, final @Nullable Comparator<Object[]> cmpPartitionBy, final int numCellsInSourceRow, final List<WindowFunction> windowFunctions, final List<? extends CollectExpression<Row, ?>> argsExpressions, final Boolean[] ignoreNulls, final Input<?>[] ... args) {
        return () -> new Iterator<Object[]>(){
            private boolean isTraceEnabled = LOGGER.isTraceEnabled();
            private final int start = 0;
            private final int end = sortedRows.size();
            private final WindowFrameState frame = new WindowFrameState(0, this.end, sortedRows);
            private int pStart = 0;
            private int pEnd = Lists.findFirstNonPeer((List)sortedRows, (int)this.pStart, (int)this.end, (Comparator)cmpPartitionBy);
            private int i = 0;
            private int idxInPartition = 0;

            @Override
            public boolean hasNext() {
                return this.i < this.end;
            }

            @Override
            public Object[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i == this.pEnd) {
                    this.pStart = this.i;
                    this.idxInPartition = 0;
                    this.pEnd = Lists.findFirstNonPeer((List)sortedRows, (int)this.pStart, (int)this.end, (Comparator)cmpPartitionBy);
                }
                int wBegin = computeFrameStart.apply(this.pStart, this.pEnd, this.i, sortedRows);
                int wEnd = computeFrameEnd.apply(this.pStart, this.pEnd, this.i, sortedRows);
                this.frame.updateBounds(this.pStart, this.pEnd, wBegin, wEnd);
                Object[] row = WindowFunctionBatchIterator.computeAndInjectResults(sortedRows, allocateBytes, numCellsInSourceRow, windowFunctions, this.frame, this.i, this.idxInPartition, argsExpressions, ignoreNulls, args);
                if (this.isTraceEnabled) {
                    LOGGER.trace("idx={} idxInPartition={} pStart={} pEnd={} wBegin={} wEnd={} row={}", (Object)this.i, (Object)this.idxInPartition, (Object)this.pStart, (Object)this.pEnd, (Object)wBegin, (Object)wEnd, (Object)Arrays.toString((Object[])sortedRows.get(this.i)));
                }
                ++this.i;
                ++this.idxInPartition;
                return row;
            }
        };
    }

    @Nullable
    private static Comparator<Object[]> joinCmp(@Nullable Comparator<Object[]> cmpPartitionBy, @Nullable Comparator<Object[]> cmpOrderBy) {
        if (cmpPartitionBy == null) {
            return cmpOrderBy;
        }
        if (cmpOrderBy == null) {
            return cmpPartitionBy;
        }
        return cmpPartitionBy.thenComparing(cmpOrderBy);
    }

    private static Object[] computeAndInjectResults(List<Object[]> rows, LongConsumer allocateBytes, int numCellsInSourceRow, List<WindowFunction> windowFunctions, WindowFrameState frame, int idx, int idxInPartition, List<? extends CollectExpression<Row, ?>> argsExpressions, Boolean[] ignoreNulls, Input<?>[] ... args) {
        Object[] row = rows.get(idx);
        for (int c = 0; c < windowFunctions.size(); ++c) {
            Object result;
            WindowFunction windowFunction = windowFunctions.get(c);
            row[numCellsInSourceRow + c] = result = windowFunction.execute(allocateBytes, idxInPartition, frame, argsExpressions, ignoreNulls[c], args[c]);
        }
        return row;
    }
}

