/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.common.exceptions.Exceptions;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.jobs.DownstreamRXTask;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.Task;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistResultRXTask
implements Task,
DownstreamRXTask {
    private final int id;
    private final String name;
    private final int numBuckets;
    private final PageBucketReceiver pageBucketReceiver;
    private final CompletableFuture<Void> completionFuture;
    private final RamAccounting ramAccounting;
    private long totalBytesUsed = -1L;

    public DistResultRXTask(int id, String name, PageBucketReceiver pageBucketReceiver, RamAccounting ramAccounting, int numBuckets) {
        this.id = id;
        this.name = name;
        this.numBuckets = numBuckets;
        this.pageBucketReceiver = pageBucketReceiver;
        this.ramAccounting = ramAccounting;
        this.completionFuture = pageBucketReceiver.completionFuture().handle((result, ex) -> {
            this.totalBytesUsed = ramAccounting.totalBytes();
            if (ex instanceof IllegalStateException) {
                this.kill((Throwable)ex);
            }
            if (ex == null) {
                return null;
            }
            throw Exceptions.toRuntimeException((Throwable)ex);
        });
    }

    public void kill(@NotNull Throwable t) {
        this.pageBucketReceiver.kill(t);
    }

    @Override
    public CompletableFuture<Void> start() {
        if (this.numBuckets == 0) {
            this.pageBucketReceiver.consumeRows();
        }
        return null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int id() {
        return this.id;
    }

    public String toString() {
        return "DistResultRXTask{id=" + this.id() + ", numBuckets=" + this.numBuckets + ", isDone=" + this.completionFuture.isDone() + ", pageBucketReceiver=" + String.valueOf(this.pageBucketReceiver) + "}";
    }

    @Override
    @Nullable
    public PageBucketReceiver getBucketReceiver(byte inputId) {
        return this.pageBucketReceiver;
    }

    @Override
    public CompletableFuture<Void> completionFuture() {
        return this.completionFuture;
    }

    @Override
    public long bytesUsed() {
        if (this.totalBytesUsed == -1L) {
            return this.ramAccounting.totalBytes();
        }
        return this.totalBytesUsed;
    }
}

