/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import io.crate.role.Role;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class KillJobsNodeRequest
extends TransportRequest {
    private final List<String> excludedNodeIds;
    private final KillJobsRequest killJobsRequest;

    public KillJobsNodeRequest(List<String> excludedNodeIds, Collection<UUID> jobsToKill, String userName, @Nullable String reason) {
        this.killJobsRequest = new KillJobsRequest(jobsToKill, userName, reason);
        this.excludedNodeIds = excludedNodeIds;
    }

    public List<String> excludedNodeIds() {
        return this.excludedNodeIds;
    }

    public KillJobsRequest innerRequest() {
        return this.killJobsRequest;
    }

    @VisibleForTesting
    public static class KillJobsRequest
    extends TransportRequest {
        private final Collection<UUID> toKill;
        private final String userName;
        @Nullable
        private final String reason;

        private KillJobsRequest(Collection<UUID> jobsToKill, String userName, @Nullable String reason) {
            this.toKill = jobsToKill;
            this.userName = userName;
            this.reason = reason;
        }

        public Collection<UUID> toKill() {
            return this.toKill;
        }

        KillJobsRequest(StreamInput in) throws IOException {
            super(in);
            int numJobs = in.readVInt();
            this.toKill = new ArrayList<UUID>(numJobs);
            for (int i = 0; i < numJobs; ++i) {
                UUID job = new UUID(in.readLong(), in.readLong());
                this.toKill.add(job);
            }
            this.reason = in.getVersion().onOrAfter(Version.V_4_1_0) ? in.readOptionalString() : null;
            this.userName = in.getVersion().onOrAfter(Version.V_4_3_0) ? in.readString() : Role.CRATE_USER.name();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            int numJobs = this.toKill.size();
            out.writeVInt(numJobs);
            for (UUID job : this.toKill) {
                out.writeLong(job.getMostSignificantBits());
                out.writeLong(job.getLeastSignificantBits());
            }
            if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
                out.writeOptionalString(this.reason);
            }
            if (out.getVersion().onOrAfter(Version.V_4_3_0)) {
                out.writeString(this.userName);
            }
        }

        public String toString() {
            return "KillJobsRequest{" + String.valueOf(this.toKill) + "}";
        }

        @Nullable
        public String reason() {
            return this.reason;
        }

        public String userName() {
            return this.userName;
        }
    }
}

