/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.transport;

import io.crate.concurrent.MultiActionListener;
import io.crate.execution.jobs.transport.CancelRequest;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.session.Sessions;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportCancelAction
extends TransportAction<CancelRequest, AcknowledgedResponse> {
    public static final String NAME = "internal:crate:pg/cancel";
    public static final ActionType<AcknowledgedResponse> ACTION = new ActionType("internal:crate:pg/cancel");
    private final Sessions sessions;
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public TransportCancelAction(Sessions sessions, ClusterService clusterService, TransportService transportService) {
        super(NAME);
        this.sessions = sessions;
        this.clusterService = clusterService;
        this.transportService = transportService;
        NodeAction nodeAction = this::nodeOperation;
        transportService.registerRequestHandler(NAME, "same", true, false, CancelRequest::new, new NodeActionRequestHandler(nodeAction));
    }

    @Override
    protected void doExecute(CancelRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        MultiActionListener<Object, Object, AcknowledgedResponse> multiActionListener = new MultiActionListener<Object, Object, AcknowledgedResponse>(nodes.getSize() - 1, () -> null, (x, y) -> {}, state -> new AcknowledgedResponse(true), finalListener);
        for (DiscoveryNode node : nodes) {
            if (node.equals(this.clusterService.localNode())) continue;
            this.transportService.sendRequest(node, NAME, request, new ActionListenerResponseHandler<AcknowledgedResponse>(NAME, multiActionListener, AcknowledgedResponse::new));
        }
    }

    CompletableFuture<TransportResponse> nodeOperation(CancelRequest request) {
        this.sessions.cancelLocally(request.keyData());
        return CompletableFuture.completedFuture(TransportResponse.Empty.INSTANCE);
    }
}

