/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.eval;

import io.crate.expression.operator.Operators;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import java.util.function.UnaryOperator;

public final class NullEliminator {
    private static final Visitor VISITOR = new Visitor();

    public static Symbol eliminateNullsIfPossible(Symbol symbol, UnaryOperator<Symbol> postProcessor) {
        return symbol.accept(VISITOR, new Context(postProcessor));
    }

    private NullEliminator() {
    }

    private static class Visitor
    extends FunctionCopyVisitor<Context> {
        private Visitor() {
        }

        @Override
        public Symbol visitFunction(Function func, Context context) {
            String functionName = func.name();
            if (Operators.LOGICAL_OPERATORS.contains(functionName)) {
                Object newFunc;
                boolean currentNullReplacement = context.nullReplacement;
                boolean currentInsideLogicalOperator = context.insideLogicalOperator;
                context.insideLogicalOperator = true;
                if ("op_not".equals(functionName)) {
                    boolean bl = context.nullReplacement = !currentNullReplacement;
                }
                if ((newFunc = super.visitFunction(func, context)) != func) {
                    newFunc = (Symbol)context.postProcessor.apply((Symbol)newFunc);
                }
                context.insideLogicalOperator = currentInsideLogicalOperator;
                context.nullReplacement = currentNullReplacement;
                return newFunc;
            }
            return func;
        }

        @Override
        public Symbol visitLiteral(Literal<?> symbol, Context context) {
            if (context.insideLogicalOperator && symbol.value() == null) {
                return Literal.of(context.nullReplacement);
            }
            return symbol;
        }
    }

    private static class Context {
        private final UnaryOperator<Symbol> postProcessor;
        boolean insideLogicalOperator = false;
        boolean nullReplacement = false;

        public Context(UnaryOperator<Symbol> postProcessor) {
            this.postProcessor = postProcessor;
        }
    }
}

