/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.symbol.Literal;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import java.util.function.IntPredicate;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public final class CmpOperator
extends Operator<Object> {
    private final IntPredicate isMatch;
    private final DataType<Object> type;

    public CmpOperator(Signature signature, BoundSignature boundSignature, IntPredicate cmpResultIsMatch) {
        super(signature, boundSignature);
        this.type = boundSignature.argTypes().get(0);
        this.isMatch = cmpResultIsMatch;
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null && args[1] != null) : "1st and 2nd argument must not be null";
        Object left = args[0].value();
        Object right = args[1].value();
        if (left == null || right == null) {
            return null;
        }
        assert (left.getClass().equals(right.getClass())) : "left and right must have the same type for comparison";
        return this.isMatch.test(this.type.compare(left, right));
    }

    public static Query toQuery(String functionName, Reference ref, Object value) {
        StorageSupport<?> storageSupport = ref.valueType().storageSupport();
        if (storageSupport == null) {
            return null;
        }
        EqQuery<?> eqQuery = storageSupport.eqQuery();
        if (eqQuery == null) {
            return new MatchNoDocsQuery("For types that do not support EqQuery, a `x [>, >=, <, <=] <value>` is always considered a no-match");
        }
        String field = ref.storageIdent();
        return switch (functionName) {
            case "op_>" -> eqQuery.rangeQuery(field, value, null, false, false, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
            case "op_>=" -> eqQuery.rangeQuery(field, value, null, true, false, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
            case "op_<" -> eqQuery.rangeQuery(field, null, value, false, false, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
            case "op_<=" -> eqQuery.rangeQuery(field, null, value, false, true, ref.hasDocValues(), ref.indexType() != IndexType.NONE);
            default -> throw new IllegalArgumentException(functionName + " is not a supported comparison operator");
        };
    }

    @Override
    public Query toQuery(Reference ref, Literal<?> literal) {
        return CmpOperator.toQuery(this.signature.getName().name(), ref, literal.value());
    }
}

