/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.predicate;

import io.crate.analyze.MatchOptionsAnalysis;
import io.crate.data.Input;
import io.crate.execution.dml.GeoShapeIndexer;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.geo.GeoJSONUtils;
import io.crate.geo.LatLonShapeUtils;
import io.crate.lucene.FunctionToQuery;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.lucene.match.OptionParser;
import io.crate.lucene.match.ParsedOptions;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.GeoReference;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.MultiMatchQueryType;
import org.elasticsearch.index.search.MatchQuery;
import org.elasticsearch.index.search.MultiMatchQuery;
import org.jetbrains.annotations.Nullable;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class MatchPredicate
implements FunctionImplementation,
FunctionToQuery {
    public static final String NAME = "match";
    public static final Signature TEXT_MATCH = Signature.builder("match", FunctionType.SCALAR).argumentTypes(DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNTYPED_OBJECT.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build();
    public static final Signature GEO_MATCH = Signature.builder("match", FunctionType.SCALAR).argumentTypes(DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.GEO_SHAPE.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNTYPED_OBJECT.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build();
    public static final Set<DataType<?>> SUPPORTED_TYPES = Set.of(DataTypes.STRING, DataTypes.GEO_SHAPE);
    private static final Map<DataType<?>, String> DATA_TYPE_TO_DEFAULT_MATCH_TYPE = Map.of(DataTypes.STRING, MultiMatchQueryType.BEST_FIELDS.toString().toLowerCase(Locale.ENGLISH), DataTypes.GEO_SHAPE, "intersects");
    private static final Set<String> SUPPORTED_GEO_MATCH_TYPES = Set.of("intersects", "disjoint", "within");
    private final Signature signature;
    private final BoundSignature boundSignature;

    public static void register(Functions.Builder builder) {
        builder.add(GEO_MATCH, MatchPredicate::new);
        builder.add(TEXT_MATCH, MatchPredicate::new);
    }

    private MatchPredicate(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    private static String defaultMatchType(DataType<?> dataType) {
        String matchType = DATA_TYPE_TO_DEFAULT_MATCH_TYPE.get(dataType);
        if (matchType == null) {
            throw new IllegalArgumentException("No default matchType found for dataType: " + String.valueOf(dataType));
        }
        return matchType;
    }

    public static String getMatchType(@Nullable String matchType, DataType<?> columnType) {
        if (matchType == null) {
            return MatchPredicate.defaultMatchType(columnType);
        }
        if (columnType.equals(DataTypes.STRING)) {
            try {
                MultiMatchQueryType.parse(matchType);
                return matchType;
            }
            catch (ElasticsearchParseException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid MATCH type '%s' for type '%s'", matchType, columnType), e);
            }
        }
        if (columnType.equals(DataTypes.GEO_SHAPE)) {
            if (!SUPPORTED_GEO_MATCH_TYPES.contains(matchType)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "invalid MATCH type '%s' for type '%s', valid types are: [%s]", matchType, columnType, String.join((CharSequence)",", SUPPORTED_GEO_MATCH_TYPES)));
            }
            return matchType;
        }
        throw new IllegalArgumentException("No match type for dataType: " + String.valueOf(columnType));
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        List<Symbol> arguments = function.arguments();
        assert (arguments.size() == 4) : "invalid number of arguments";
        assert (Symbol.isLiteral(arguments.get(0), DataTypes.UNTYPED_OBJECT)) : "fields must be literal";
        assert (Symbol.isLiteral(arguments.get(2), DataTypes.STRING)) : "matchType must be literal";
        Symbol queryTerm = arguments.get(1);
        if (!(queryTerm instanceof Input)) {
            throw new IllegalArgumentException("queryTerm must be a literal");
        }
        Input input = (Input)queryTerm;
        Object queryTermVal = input.value();
        if (queryTermVal == null) {
            throw new IllegalArgumentException("cannot use NULL as query term in match predicate");
        }
        if (queryTerm.valueType().equals(DataTypes.GEO_SHAPE)) {
            return this.geoMatch(context, arguments, queryTermVal);
        }
        return MatchPredicate.stringMatch(context, arguments, queryTermVal);
    }

    private Query geoMatch(LuceneQueryBuilder.Context context, List<Symbol> arguments, Object queryTerm) {
        Map fields = (Map)((Literal)arguments.get(0)).value();
        String fieldName = (String)fields.keySet().iterator().next();
        Reference ref = context.getRef(fieldName);
        while (ref instanceof GeneratedReference) {
            GeneratedReference genRef = (GeneratedReference)ref;
            ref = genRef.reference();
        }
        if (ref == null || !(ref instanceof GeoReference)) {
            return Queries.newUnmappedFieldQuery(fieldName);
        }
        GeoReference geoRef = (GeoReference)ref;
        String matchType = (String)((Input)arguments.get(2)).value();
        ShapeRelation relation = ShapeRelation.getRelationByName(matchType);
        assert (relation != null) : "invalid matchType: " + matchType;
        Map geoJSONMap = (Map)queryTerm;
        String tree = geoRef.geoTree();
        if ("bkdtree".equals(tree)) {
            return MatchPredicate.bkdTreeQuery(fieldName, relation, geoJSONMap);
        }
        return MatchPredicate.prefixTreeQuery(fieldName, geoRef, relation, geoJSONMap);
    }

    private static Query bkdTreeQuery(String fieldName, ShapeRelation relation, Map<String, Object> geoJSONMap) {
        Object shape = GeoJSONUtils.map2LuceneShape(geoJSONMap);
        return new ConstantScoreQuery(LatLonShapeUtils.newLatLonShapeQuery(fieldName, relation.getLuceneRelation(), shape));
    }

    private static Query prefixTreeQuery(String fieldName, GeoReference geoReference, ShapeRelation relation, Map<String, Object> geoJSONMap) {
        Shape shape = GeoJSONUtils.map2Shape(geoJSONMap);
        PrefixTreeStrategy prefixTreeStrategy = MatchPredicate.defaultStrategy(geoReference);
        if (relation == ShapeRelation.DISJOINT) {
            BooleanQuery.Builder bool = new BooleanQuery.Builder();
            TermRangeQuery exists = new TermRangeQuery(fieldName, null, null, true, true);
            Query intersects = prefixTreeStrategy.makeQuery(MatchPredicate.getArgs(shape, ShapeRelation.INTERSECTS));
            bool.add((Query)exists, BooleanClause.Occur.MUST);
            bool.add(intersects, BooleanClause.Occur.MUST_NOT);
            return new ConstantScoreQuery((Query)bool.build());
        }
        SpatialArgs spatialArgs = MatchPredicate.getArgs(shape, relation);
        return prefixTreeStrategy.makeQuery(spatialArgs);
    }

    public static double defaultDistanceErrorPct(int treeLevels, double precisionInMeters) {
        return treeLevels == 0 && precisionInMeters < 0.0 ? 0.025 : 0.0;
    }

    public static PrefixTreeStrategy defaultStrategy(GeoReference geoReference) {
        String geoTree;
        String precision;
        Integer treeLevels = geoReference.treeLevels();
        if (treeLevels == null) {
            treeLevels = 0;
        }
        double precisionInMeters = (precision = geoReference.precision()) == null ? -1.0 : DistanceUnit.parse(precision, DistanceUnit.DEFAULT, DistanceUnit.DEFAULT);
        Double distanceErrorPct = geoReference.distanceErrorPct();
        GeohashPrefixTree prefixTree = switch (geoTree = geoReference.geoTree()) {
            case "geohash" -> new GeohashPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, MatchPredicate.getLevels(treeLevels, precisionInMeters, GeoShapeIndexer.Defaults.GEOHASH_LEVELS, true));
            case "legacyquadtree" -> new QuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, MatchPredicate.getLevels(treeLevels, precisionInMeters, GeoShapeIndexer.Defaults.QUADTREE_LEVELS, false));
            case "quadtree" -> new PackedQuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, MatchPredicate.getLevels(treeLevels, precisionInMeters, GeoShapeIndexer.Defaults.QUADTREE_LEVELS, false));
            default -> throw new IllegalArgumentException("Unknown prefix tree type: " + geoTree);
        };
        RecursivePrefixTreeStrategy recursiveStrategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)prefixTree, geoReference.storageIdent());
        recursiveStrategy.setDistErrPct(distanceErrorPct == null ? MatchPredicate.defaultDistanceErrorPct(treeLevels, precisionInMeters) : distanceErrorPct);
        recursiveStrategy.setPruneLeafyBranches(false);
        return recursiveStrategy;
    }

    private static int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
        if (treeLevels > 0 || precisionInMeters >= 0.0) {
            return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision(precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision(precisionInMeters)) : 0);
        }
        return defaultLevels;
    }

    private static SpatialArgs getArgs(Shape shape, ShapeRelation relation) {
        switch (relation) {
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, shape);
            }
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, shape);
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, shape);
            }
        }
        throw MatchPredicate.invalidMatchType(relation.getRelationName());
    }

    private static AssertionError invalidMatchType(String matchType) {
        throw new AssertionError((Object)String.format(Locale.ENGLISH, "Invalid match type: %s. Analyzer should have made sure that it is valid", matchType));
    }

    private static Query stringMatch(LuceneQueryBuilder.Context context, List<Symbol> arguments, Object queryTerm) {
        Map fields = (Map)((Literal)arguments.get(0)).value();
        String queryString = (String)queryTerm;
        String matchType = (String)((Literal)arguments.get(2)).value();
        Map options = (Map)((Literal)arguments.get(3)).value();
        MatchOptionsAnalysis.validate(options);
        if (fields.size() == 1) {
            return MatchPredicate.singleMatchQuery(context, fields.entrySet().iterator().next(), queryString, matchType, options);
        }
        fields.replaceAll((s, o) -> {
            if (o instanceof Number) {
                Number number = (Number)o;
                return Float.valueOf(number.floatValue());
            }
            return null;
        });
        return MatchPredicate.multiMatch(context, matchType, fields, queryString, options);
    }

    private static Query singleMatchQuery(LuceneQueryBuilder.Context context, Map.Entry<String, Object> entry, String queryString, String matchType, Map<String, Object> options) {
        MultiMatchQueryType type = MatchPredicate.getType(matchType);
        ParsedOptions parsedOptions = OptionParser.parse(type, options);
        MatchQuery matchQuery = new MatchQuery(context, parsedOptions);
        MatchQuery.Type matchQueryType = type.matchQueryType();
        String fieldName = entry.getKey();
        Query query = matchQuery.parse(matchQueryType, fieldName, queryString);
        Object boost = entry.getValue();
        if (boost instanceof Number) {
            Number number = (Number)boost;
            return new BoostQuery(query, number.floatValue());
        }
        return query;
    }

    private static Query multiMatch(LuceneQueryBuilder.Context context, @Nullable String matchType, Map<String, Float> fieldNames, String queryString, Map<String, Object> options) {
        MultiMatchQueryType type = MatchPredicate.getType(matchType);
        ParsedOptions parsedOptions = OptionParser.parse(type, options);
        MultiMatchQuery multiMatchQuery = new MultiMatchQuery(context, parsedOptions);
        return multiMatchQuery.parse(type, fieldNames, queryString, parsedOptions.minimumShouldMatch());
    }

    private static MultiMatchQueryType getType(@Nullable String matchType) {
        if (matchType == null) {
            return MultiMatchQueryType.BEST_FIELDS;
        }
        return MultiMatchQueryType.parse(matchType);
    }
}

