/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import io.crate.metadata.IndexName;
import java.util.Arrays;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.indices.ShardLimitValidator;

@Singleton
public class MaxShardsPerNodeSysCheck
extends AbstractSysNodeCheck {
    static final int ID = 8;
    private static final String DESCRIPTION = "The amount of shards on the node reached 90 % of the limit of the cluster setting `cluster.max_shards_per_node`. Creating new tables or partitions which would push the number of shards beyond 100 % of the limit will be rejected.";
    private static final double PERCENTAGE_MAX_SHARDS_PER_NODE_THRESHOLD = 0.9;
    private final ClusterService clusterService;

    @Inject
    public MaxShardsPerNodeSysCheck(ClusterService clusterService) {
        super(8, DESCRIPTION, SysCheck.Severity.MEDIUM);
        this.clusterService = clusterService;
    }

    @Override
    public boolean isValid() {
        double maxShardLimitPerNode = this.clusterService.getClusterSettings().get(ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE).doubleValue();
        ClusterState cs = this.clusterService.state();
        String localNodeId = cs.nodes().getLocalNodeId();
        double numberOfShardsOnLocalNode = 0.0;
        for (ShardRouting shardRouting : MaxShardsPerNodeSysCheck.shardsForOpenIndices(cs)) {
            if (!localNodeId.equals(shardRouting.currentNodeId())) continue;
            numberOfShardsOnLocalNode += 1.0;
        }
        return numberOfShardsOnLocalNode / maxShardLimitPerNode < 0.9;
    }

    private static Iterable<ShardRouting> shardsForOpenIndices(ClusterState clusterState) {
        String[] concreteIndices = (String[])Arrays.stream(clusterState.metadata().getConcreteAllOpenIndices()).filter(index -> !IndexName.isDangling(index)).toArray(String[]::new);
        return clusterState.routingTable().allShards(concreteIndices);
    }
}

