/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;

@Singleton
public class RecoveryAfterNodesSysCheck
extends AbstractSysNodeCheck {
    private final ClusterService clusterService;
    private final Settings settings;
    static final int ID = 2;
    private static final String DESCRIPTION = "The cluster setting 'gateway.recover_after_data_nodes' (or the deprecated `gateway.recovery_after_nodes` setting) is not configured or it is set to a value that seems low in relation to the the maximum/expected number of (data) nodes in the cluster.";

    @Inject
    public RecoveryAfterNodesSysCheck(ClusterService clusterService, Settings settings) {
        super(2, DESCRIPTION, SysCheck.Severity.MEDIUM);
        this.clusterService = clusterService;
        this.settings = settings;
    }

    @Override
    public boolean isValid() {
        int actualNodes = this.clusterService.state().nodes().getDataNodes().size();
        int afterNodes = GatewayService.RECOVER_AFTER_DATA_NODES_SETTING.get(this.settings);
        int expectedNodes = GatewayService.EXPECTED_DATA_NODES_SETTING.get(this.settings);
        if (afterNodes == -1 || expectedNodes == -1) {
            actualNodes = this.clusterService.state().nodes().getSize();
            afterNodes = GatewayService.RECOVER_AFTER_NODES_SETTING.get(this.settings);
            expectedNodes = GatewayService.EXPECTED_NODES_SETTING.get(this.settings);
        }
        return RecoveryAfterNodesSysCheck.validate(afterNodes, expectedNodes, actualNodes);
    }

    private static boolean validate(int afterNodes, int expectedNodes, int actualNodes) {
        return actualNodes == 1 || expectedNodes / 2 < afterNodes && afterNodes <= expectedNodes;
    }
}

