/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.snapshot;

import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.List;
import java.util.stream.Stream;

public class SysSnapshot {
    private final String uuid;
    private final String name;
    private final String repository;
    private final List<String> concreteIndices;
    private final List<String> partitionedTables;
    private final Long started;
    private final Long finished;
    private final String version;
    private final String state;
    private final String reason;
    private final int totalShards;
    private final Boolean includeGlobalState;
    private final List<String> snapshotShardFailures;

    public SysSnapshot(String uuid, String name, String repository, List<String> concreteIndices, List<String> partitionedTables, Long started, Long finished, String version, String state, List<String> snapshotShardFailures, String reason, int totalShards, Boolean includeGlobalState) {
        this.uuid = uuid;
        this.name = name;
        this.repository = repository;
        this.concreteIndices = concreteIndices;
        this.partitionedTables = partitionedTables;
        this.started = started;
        this.finished = finished;
        this.version = version;
        this.state = state;
        this.snapshotShardFailures = snapshotShardFailures;
        this.reason = reason;
        this.totalShards = totalShards;
        this.includeGlobalState = includeGlobalState;
    }

    public String uuid() {
        return this.uuid;
    }

    public String name() {
        return this.name;
    }

    public String repository() {
        return this.repository;
    }

    public List<String> concreteIndices() {
        return this.concreteIndices;
    }

    public Long started() {
        return this.started;
    }

    public Long finished() {
        return this.finished;
    }

    public String version() {
        return this.version;
    }

    public String state() {
        return this.state;
    }

    public List<String> failures() {
        return this.snapshotShardFailures;
    }

    public String reason() {
        return this.reason;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<String> tables() {
        return Stream.concat(this.concreteIndices.stream().map(RelationName::fqnFromIndexName), this.partitionedTables.stream()).distinct().toList();
    }

    public List<RelationName> relationNames() {
        return Stream.concat(this.concreteIndices.stream().map(RelationName::fromIndexName), this.partitionedTables.stream().map(RelationName::fromIndexName)).distinct().toList();
    }

    public List<PartitionName> tablePartitions() {
        return this.concreteIndices.stream().map(IndexName::decode).filter(IndexParts::isPartitioned).map(indexParts -> new PartitionName(new RelationName(indexParts.schema(), indexParts.table()), indexParts.partitionIdent())).toList();
    }
}

