/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.snapshot;

import io.crate.common.collections.Lists;
import io.crate.common.concurrent.CompletableFutures;
import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import io.crate.expression.reference.sys.snapshot.SysSnapshot;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SysSnapshots {
    private static final Logger LOGGER = LogManager.getLogger(SysSnapshots.class);
    private final Supplier<Collection<Repository>> getRepositories;
    private final ClusterService clusterService;

    @Inject
    public SysSnapshots(RepositoriesService repositoriesService, ClusterService clusterService) {
        this(repositoriesService::getRepositoriesList, clusterService);
    }

    @VisibleForTesting
    SysSnapshots(Supplier<Collection<Repository>> getRepositories, ClusterService clusterService) {
        this.getRepositories = getRepositories;
        this.clusterService = clusterService;
    }

    public CompletableFuture<Iterable<SysSnapshot>> currentSnapshots() {
        ArrayList<CompletionStage> sysSnapshots = new ArrayList<CompletionStage>();
        for (Repository repository : this.getRepositories.get()) {
            CompletionStage futureSnapshots = repository.getRepositoryData().thenCompose(repositoryData -> {
                Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
                ArrayList<CompletableFuture<SysSnapshot>> snapshots = new ArrayList<CompletableFuture<SysSnapshot>>(snapshotIds.size());
                for (SnapshotId snapshotId : snapshotIds) {
                    snapshots.add(SysSnapshots.createSysSnapshot(repository, snapshotId));
                }
                return CompletableFutures.allSuccessfulAsList(snapshots);
            });
            sysSnapshots.add(futureSnapshots);
            SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)this.clusterService.state().custom("snapshots");
            List<SysSnapshot> inProgressSnapshots = SysSnapshots.snapshotsInProgress(snapshotsInProgress, repository.getMetadata().name());
            sysSnapshots.add(CompletableFuture.completedFuture(inProgressSnapshots));
        }
        return CompletableFutures.allSuccessfulAsList(sysSnapshots).thenApply(data -> {
            ArrayList result = new ArrayList();
            for (Collection datum : data) {
                result.addAll(datum);
            }
            return result;
        });
    }

    private static SysSnapshot toSysSnapshot(Repository repository, SnapshotId snapshotId, SnapshotInfo snapshotInfo, List<String> partedTables) {
        Version version = snapshotInfo.version();
        return new SysSnapshot(snapshotId.getUUID(), snapshotId.getName(), repository.getMetadata().name(), snapshotInfo.indices(), partedTables, snapshotInfo.startTime(), snapshotInfo.endTime(), version == null ? null : version.toString(), snapshotInfo.state().name(), Lists.map(snapshotInfo.shardFailures(), SnapshotShardFailure::toString), snapshotInfo.reason(), snapshotInfo.totalShards(), snapshotInfo.includeGlobalState());
    }

    private static SysSnapshot toSysSnapshot(String repositoryName, SnapshotsInProgress.Entry entry, List<String> partedTables) {
        return new SysSnapshot(entry.snapshot().getSnapshotId().getUUID(), entry.snapshot().getSnapshotId().getName(), repositoryName, entry.indices().stream().map(IndexId::getName).toList(), partedTables, entry.startTime(), 0L, Version.CURRENT.toString(), SnapshotState.IN_PROGRESS.name(), Collections.emptyList(), entry.failure(), entry.shards().size(), entry.includeGlobalState());
    }

    private static CompletableFuture<SysSnapshot> createSysSnapshot(Repository repository, SnapshotId snapshotId) {
        return ((CompletableFuture)repository.getSnapshotGlobalMetadata(snapshotId).thenCombine(repository.getSnapshotInfo(snapshotId), (metadata, snapshotInfo) -> {
            List<String> partedTables = metadata.relations(RelationMetadata.Table.class).stream().filter(t -> !t.partitionedBy().isEmpty()).map(t -> t.name().fqn()).toList();
            return SysSnapshots.toSysSnapshot(repository, snapshotId, snapshotInfo, partedTables);
        })).exceptionally(t -> {
            Throwable err = SQLExceptions.unwrap(t);
            if (err instanceof SnapshotException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Couldn't retrieve snapshotId={} error={}", (Object)snapshotId, (Object)err);
                }
                return new SysSnapshot(snapshotId.getUUID(), snapshotId.getName(), repository.getMetadata().name(), Collections.emptyList(), Collections.emptyList(), null, null, null, SnapshotState.FAILED.name(), List.of(), null, 0, null);
            }
            throw Exceptions.toRuntimeException((Throwable)err);
        });
    }

    public static List<SysSnapshot> snapshotsInProgress(@Nullable SnapshotsInProgress snapshotsInProgress, String repositoryName) {
        ArrayList<SysSnapshot> sysSnapshots = new ArrayList<SysSnapshot>();
        List<SnapshotsInProgress.Entry> entries = SnapshotsService.currentSnapshots(snapshotsInProgress, repositoryName, Collections.emptyList());
        for (SnapshotsInProgress.Entry entry : entries) {
            ArrayList<String> partedTables = new ArrayList<String>();
            for (RelationName relationName : entry.relationNames()) {
                partedTables.add(relationName.fqn());
            }
            sysSnapshots.add(SysSnapshots.toSysSnapshot(repositoryName, entry, partedTables));
        }
        return sysSnapshots;
    }
}

