/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class ArrayLowerFunction
extends Scalar<Integer, Object> {
    public static final String NAME = "array_lower";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), ArrayLowerFunction::new);
    }

    public ArrayLowerFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.argTypes(), NAME);
    }

    @Override
    public Integer evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        List values = (List)args[0].value();
        Object dimensionArg = args[1].value();
        if (values == null || values.isEmpty() || dimensionArg == null) {
            return null;
        }
        int dimension = (Integer)dimensionArg;
        if (dimension <= 0) {
            return null;
        }
        return ArrayLowerFunction.lowerBound(values, dimension, 1);
    }

    static final Integer lowerBound(@Nullable Object arrayOrItem, int requestedDimension, int currentDimension) {
        if (arrayOrItem instanceof List) {
            List dimensionArray = (List)arrayOrItem;
            if (currentDimension == requestedDimension) {
                return dimensionArray.isEmpty() ? null : Integer.valueOf(1);
            }
            for (Object object : dimensionArray) {
                Integer lower = ArrayLowerFunction.lowerBound(object, requestedDimension, currentDimension + 1);
                if (lower != null) continue;
                return null;
            }
            return 1;
        }
        return null;
    }
}

