/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ArrayUniqueFunction
extends Scalar<List<Object>, List<Object>> {
    public static final String NAME = "array_unique";
    private final DataType<?> elementType;

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), ArrayUniqueFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), ArrayUniqueFunction::new);
    }

    private ArrayUniqueFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.elementType = ((ArrayType)boundSignature.returnType()).innerType();
        List<DataType<?>> argumentTypes = boundSignature.argTypes();
        if (argumentTypes.size() == 1) {
            ArrayArgumentValidators.ensureSingleArgumentArrayInnerTypeIsNotUndefined(argumentTypes);
        } else {
            ArrayArgumentValidators.ensureBothInnerTypesAreNotUndefined(boundSignature.argTypes(), NAME);
        }
    }

    @Override
    public List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        HashSet uniqueSet = new HashSet();
        ArrayList<Object> uniqueItems = new ArrayList<Object>();
        for (Input array : args) {
            assert (array != null) : "inputs must never be null";
            List values = (List)array.value();
            if (values == null) continue;
            for (Object element : values) {
                Object value = this.elementType.sanitizeValue(element);
                if (!uniqueSet.add(value)) continue;
                uniqueItems.add(value);
            }
        }
        return uniqueItems;
    }
}

