/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ArrayAppendFunction;
import io.crate.expression.scalar.ArrayCatFunction;
import io.crate.expression.scalar.ArrayPrependFunction;
import io.crate.expression.scalar.object.ObjectMergeFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public abstract class ConcatFunction
extends Scalar<String, String> {
    public static final String NAME = "concat";
    public static final String OPERATOR_NAME = "op_||";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), StringConcatFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).setVariableArity(true).build(), GenericConcatFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), ArrayCatFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.UNTYPED_OBJECT.getTypeSignature()).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).bindActualTypes().build(), (signature, boundSignature) -> {
            DataType<?> returnType = ObjectMergeFunction.merge(boundSignature.argTypes().get(0), boundSignature.argTypes().get(1));
            return new ObjectMergeFunction((Signature)signature, boundSignature.withReturnType(returnType));
        });
        module.add(Signature.builder(OPERATOR_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new StringConcatFunction((Signature)signature, (BoundSignature)boundSignature, true));
        module.add(Signature.builder(OPERATOR_NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), ArrayCatFunction::new);
        module.add(Signature.builder(OPERATOR_NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("E")).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new ArrayAppendFunction((Signature)signature, (BoundSignature)boundSignature, true));
        module.add(Signature.builder(OPERATOR_NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new ArrayPrependFunction((Signature)signature, (BoundSignature)boundSignature, true));
        module.add(Signature.builder(OPERATOR_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.UNTYPED_OBJECT.getTypeSignature()).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).bindActualTypes().build(), (signature, boundSignature) -> {
            DataType<?> returnType = ObjectMergeFunction.merge(boundSignature.argTypes().get(0), boundSignature.argTypes().get(1));
            return new ObjectMergeFunction((Signature)signature, boundSignature.withReturnType(returnType));
        });
    }

    ConcatFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        if (ConcatFunction.anyNonLiterals(function.arguments())) {
            return function;
        }
        Input[] inputs = new Input[function.arguments().size()];
        for (int i = 0; i < function.arguments().size(); ++i) {
            inputs[i] = (Input)function.arguments().get(i);
        }
        return Literal.ofUnchecked(this.boundSignature.returnType(), this.evaluate(txnCtx, nodeCtx, inputs));
    }

    static class StringConcatFunction
    extends ConcatFunction {
        private final boolean calledByOperator;

        StringConcatFunction(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
            this.calledByOperator = false;
        }

        StringConcatFunction(Signature signature, BoundSignature boundSignature, boolean calledByOperator) {
            super(signature, boundSignature);
            this.calledByOperator = calledByOperator;
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
            String firstArg = (String)args[0].value();
            String secondArg = (String)args[1].value();
            if (this.calledByOperator && (firstArg == null || secondArg == null)) {
                return null;
            }
            if (firstArg == null) {
                if (secondArg == null) {
                    return "";
                }
                return secondArg;
            }
            if (secondArg == null) {
                return firstArg;
            }
            return firstArg + secondArg;
        }
    }

    private static class GenericConcatFunction
    extends ConcatFunction {
        public GenericConcatFunction(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                String value = (String)args[i].value();
                if (value == null) continue;
                sb.append(value);
            }
            return sb.toString();
        }
    }
}

