/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public class ConcatWsFunction
extends Scalar<String, String> {
    public static final String NAME = "concat_ws";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).setVariableArity(true).build(), ConcatWsFunction::new);
    }

    ConcatWsFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
        String separator = (String)args[0].value();
        if (separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean firstNonNullProcessed = false;
        for (int i = 1; i < args.length; ++i) {
            String value = (String)args[i].value();
            if (value == null) continue;
            if (!firstNonNullProcessed) {
                firstNonNullProcessed = true;
                sb.append(value);
                continue;
            }
            sb.append(separator).append(value);
        }
        return sb.toString();
    }
}

