/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.expression.scalar.HasPrivilegeFunction;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.RelationName;
import io.crate.metadata.Scalar;
import io.crate.metadata.Schemas;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;

public class HasTablePrivilegeFunction {
    public static final FunctionName NAME = new FunctionName("pg_catalog", "has_table_privilege");

    public static boolean checkByTableName(Roles roles, Role user, Object table, Collection<Permission> permissions, Schemas schemas) {
        String tableFqn = RelationName.fqnFromIndexName((String)table);
        return HasTablePrivilegeFunction.checkPrivileges(roles, user, tableFqn, permissions);
    }

    public static boolean checkByTableOid(Roles roles, Role user, Object table, Collection<Permission> permissions, Schemas schemas) {
        int tableOid = (Integer)table;
        RelationName relationName = schemas.getRelation(tableOid);
        String tableFqn = relationName == null ? null : relationName.fqn();
        return HasTablePrivilegeFunction.checkPrivileges(roles, user, tableFqn, permissions);
    }

    public static Collection<Permission> parsePermissions(String permissionNames) {
        String[] permissions;
        HashSet<Permission> toCheck = new HashSet<Permission>();
        for (String p : permissions = permissionNames.toLowerCase(Locale.ENGLISH).split(",")) {
            if ((p = p.trim()).equals("insert") || p.equals("update") || p.equals("delete")) {
                toCheck.add(Permission.DML);
                continue;
            }
            if (p.equals("select")) {
                toCheck.add(Permission.DQL);
                continue;
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unrecognized permission: %s", p));
        }
        return toCheck;
    }

    private static boolean checkPrivileges(Roles roles, Role user, String table, Collection<Permission> permissions) {
        for (Permission permission : permissions) {
            if (!roles.hasPrivilege(user, permission, Securable.TABLE, table)) continue;
            return true;
        }
        for (Permission permission : permissions) {
            if (!roles.hasPrivilege(user, permission, Securable.VIEW, table)) continue;
            return true;
        }
        return false;
    }

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasTablePrivilegeFunction::checkByTableName, HasTablePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasTablePrivilegeFunction::checkByTableOid, HasTablePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasTablePrivilegeFunction::checkByTableName, HasTablePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasTablePrivilegeFunction::checkByTableOid, HasTablePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByOid, HasTablePrivilegeFunction::checkByTableName, HasTablePrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByOid, HasTablePrivilegeFunction::checkByTableOid, HasTablePrivilegeFunction::parsePermissions));
    }

    private HasTablePrivilegeFunction() {
    }
}

