/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.Nullable;

public class KnnMatch
extends Scalar<Boolean, Object> {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("knn_match", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("float_vector"), TypeSignature.parse("float_vector"), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), KnnMatch::new);
    }

    public KnnMatch(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
        throw new UnsupportedOperationException("knn_match can only be used in WHERE clause for tables as it needs an index to operate on");
    }

    @Override
    @Nullable
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        List<Symbol> args = function.arguments();
        Symbol symbol = args.get(0);
        if (symbol instanceof Reference) {
            Reference ref = (Reference)symbol;
            symbol = args.get(1);
            if (symbol instanceof Literal) {
                Literal targetLiteral = (Literal)symbol;
                symbol = args.get(2);
                if (symbol instanceof Literal) {
                    Literal kLiteral = (Literal)symbol;
                    Object target = targetLiteral.value();
                    Object k = kLiteral.value();
                    if (target instanceof float[] && k instanceof Integer) {
                        return new KnnFloatVectorQuery(ref.storageIdent(), (float[])target, ((Integer)k).intValue());
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

