/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class NumericCollectionAverageFunction
extends Scalar<BigDecimal, List<BigDecimal>> {
    public static final String NAME = "collection_avg";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType<BigDecimal>(DataTypes.NUMERIC).getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), NumericCollectionAverageFunction::new);
    }

    private NumericCollectionAverageFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public BigDecimal evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<BigDecimal>> ... args) {
        List values = (List)args[0].value();
        if (values == null) {
            return null;
        }
        BigDecimal sum = new BigDecimal(0);
        long count = 0L;
        for (BigDecimal value : values) {
            sum = sum.add(value);
            ++count;
        }
        if (count > 0L) {
            return sum.divide(new BigDecimal(count), MathContext.DECIMAL128);
        }
        return null;
    }
}

