/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.operator.EqOperator;
import io.crate.expression.scalar.SubscriptObjectFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.Nullable;

public class SubscriptFunction
extends Scalar<Object, Object> {
    public static final String NAME = "subscript";
    public static final Signature SIGNATURE_ARRAY_OF_OBJECTS = Signature.builder("subscript", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(object)"), DataTypes.STRING.getTypeSignature()).returnType(TypeSignature.parse("array(undefined)")).features(Scalar.Feature.DETERMINISTIC).forbidCoercion().build();
    public static final Signature SIGNATURE_OBJECT = Signature.builder("subscript", FunctionType.SCALAR).argumentTypes(DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.UNDEFINED.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).forbidCoercion().build();
    private final Lookup lookup;
    private static final Map<String, PreFilterQueryBuilder> PRE_FILTER_QUERY_BUILDER_BY_OP = Map.of("op_=", (field, eqQuery, value) -> {
        if (value instanceof List) {
            List l = (List)value;
            return EqOperator.termsQuery(field.storageIdent(), ArrayType.unnest(field.valueType()), l, field.hasDocValues(), field.indexType());
        }
        return eqQuery.termQuery(field.storageIdent(), value, field.hasDocValues(), field.indexType() != IndexType.NONE);
    }, "op_>=", (field, eqQuery, value) -> eqQuery.rangeQuery(field.storageIdent(), value, null, true, false, field.hasDocValues(), field.indexType() != IndexType.NONE), "op_>", (field, eqQuery, value) -> eqQuery.rangeQuery(field.storageIdent(), value, null, false, false, field.hasDocValues(), field.indexType() != IndexType.NONE), "op_<=", (field, eqQuery, value) -> eqQuery.rangeQuery(field.storageIdent(), null, value, false, true, field.hasDocValues(), field.indexType() != IndexType.NONE), "op_<", (field, eqQuery, value) -> eqQuery.rangeQuery(field.storageIdent(), null, value, false, false, field.hasDocValues(), field.indexType() != IndexType.NONE));

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE_ARRAY_OF_OBJECTS, (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (BoundSignature)boundSignature, SubscriptFunction::lookupByName));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), DataTypes.INTEGER.getTypeSignature()).returnType(TypeSignature.parse("E")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (BoundSignature)boundSignature, SubscriptFunction::lookupByNumericIndex));
        module.add(SIGNATURE_OBJECT, (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (BoundSignature)boundSignature, SubscriptFunction::lookupByName));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.UNDEFINED.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.UNDEFINED.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).forbidCoercion().build(), (signature, boundSignature) -> new SubscriptFunction((Signature)signature, (BoundSignature)boundSignature, SubscriptFunction::lookupByName));
    }

    private SubscriptFunction(Signature signature, BoundSignature boundSignature, Lookup lookup) {
        super(signature, boundSignature);
        this.lookup = lookup;
    }

    @Override
    public Symbol normalizeSymbol(Function func, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol result = SubscriptFunction.evaluateIfLiterals(this, txnCtx, nodeCtx, func);
        if (result instanceof Literal) {
            return result;
        }
        if (func.arguments().get(0).valueType().id() == 12) {
            return SubscriptObjectFunction.tryToInferReturnTypeFromObjectTypeAndArguments(func);
        }
        return func;
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 2) : "invalid number of arguments";
        Object element = args[0].value();
        Object index = args[1].value();
        if (element == null || index == null) {
            return null;
        }
        return this.lookup.apply(this.boundSignature.argTypes(), element, index, txnCtx.sessionSettings().errorOnUnknownObjectKey());
    }

    static Object lookupByNumericIndex(List<DataType<?>> argTypes, Object base, Object index, boolean errorOnUnknownObjectKey) {
        List values = (List)base;
        int idx = ((Number)index).intValue();
        try {
            return values.get(idx - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    static Object lookupByName(List<DataType<?>> argTypes, Object base, Object name, boolean errorOnUnknownObjectKey) {
        DataType<?> baseType = argTypes.getFirst();
        if (base instanceof List) {
            List list = (List)base;
            ArrayList<Object> result = new ArrayList<Object>(list.size());
            for (Object item : list) {
                ArrayList unnestedArgTypes = new ArrayList();
                unnestedArgTypes.add(ArrayType.unnest(baseType));
                unnestedArgTypes.add(argTypes.get(1));
                result.add(SubscriptFunction.lookupByName(unnestedArgTypes, item, name, errorOnUnknownObjectKey));
            }
            return result;
        }
        if (base instanceof Map) {
            Map map = (Map)base;
            Object value = map.get(name);
            ColumnPolicy columnPolicy = baseType.columnPolicy();
            if (value == null) {
                assert (baseType instanceof ObjectType);
                ObjectType objType = (ObjectType)baseType;
                if (columnPolicy == ColumnPolicy.IGNORED || columnPolicy == ColumnPolicy.DYNAMIC && !errorOnUnknownObjectKey || objType.innerTypes().containsKey(name)) {
                    return null;
                }
                throw ColumnUnknownException.ofUnknownRelation("The object `" + String.valueOf(base) + "` does not contain the key `" + String.valueOf(name) + "`");
            }
            return value;
        }
        throw new IllegalArgumentException("Base argument to subscript must be an object or array-of-objects, not " + String.valueOf(base));
    }

    @Override
    public Query toQuery(Function parent, Function inner, LuceneQueryBuilder.Context context) {
        Reference ref;
        Symbol symbol;
        block8: {
            block7: {
                symbol = inner.arguments().get(0);
                if (!(symbol instanceof Reference)) break block7;
                ref = (Reference)symbol;
                if (inner.arguments().get(1) instanceof Literal && parent.arguments().size() == 2 && (symbol = parent.arguments().get(1)) instanceof Literal) break block8;
            }
            return null;
        }
        Literal cmpLiteral = (Literal)symbol;
        if (DataTypes.isArray(ref.valueType())) {
            EqQuery<Object> eqQuery;
            PreFilterQueryBuilder preFilterQueryBuilder = PRE_FILTER_QUERY_BUILDER_BY_OP.get(parent.name());
            if (preFilterQueryBuilder == null) {
                return null;
            }
            DataType<?> innerType = ArrayType.unnest(ref.valueType());
            StorageSupport<?> storageSupport = innerType.storageSupport();
            EqQuery<Object> eqQuery2 = eqQuery = storageSupport == null ? null : storageSupport.eqQuery();
            if (eqQuery == null) {
                return null;
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            Query preFilterQuery = preFilterQueryBuilder.buildQuery(ref, eqQuery, cmpLiteral.value());
            if (preFilterQuery == null) {
                return null;
            }
            builder.add(preFilterQuery, BooleanClause.Occur.MUST);
            builder.add(LuceneQueryBuilder.genericFunctionFilter(parent, context), BooleanClause.Occur.FILTER);
            return builder.build();
        }
        return null;
    }

    private static interface Lookup {
        @Nullable
        public Object apply(List<DataType<?>> var1, Object var2, Object var3, boolean var4);
    }

    private static interface PreFilterQueryBuilder {
        public Query buildQuery(Reference var1, EqQuery<Object> var2, Object var3);
    }
}

