/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.TypeSignature;
import java.util.ArrayList;

public class ArrayFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_array";
    public static final Signature SIGNATURE = Signature.builder("_array", FunctionType.SCALAR).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).argumentTypes(TypeSignature.parse("E")).returnType(TypeSignature.parse("array(E)")).setVariableArity(true).features(Scalar.Feature.NOTNULL, Scalar.Feature.DETERMINISTIC).build();

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, ArrayFunction::new);
    }

    private ArrayFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        ArrayList<Object> values = new ArrayList<Object>(args.length);
        for (Input<Object> arg : args) {
            values.add(arg.value());
        }
        return values;
    }
}

