/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.cast;

import io.crate.data.Input;
import io.crate.exceptions.ConversionException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;

public class ExplicitCastFunction
extends Scalar<Object, Object> {
    public static final String NAME = "cast";
    public static final Signature SIGNATURE = Signature.builder("cast", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), TypeSignature.parse("V")).returnType(TypeSignature.parse("V")).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E"), TypeVariableConstraint.typeVariable("V")).build();
    private final DataType<?> returnType;

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, ExplicitCastFunction::new);
    }

    private ExplicitCastFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.returnType = boundSignature.returnType();
    }

    @Override
    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        try {
            return this.returnType.explicitCast(args[0].value(), txnCtx.sessionSettings());
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ConversionException(args[0].value(), this.returnType);
        }
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol argument = symbol.arguments().get(0);
        if (argument.valueType().equals(this.returnType)) {
            return argument;
        }
        if (argument instanceof Input) {
            Object value = ((Input)argument).value();
            try {
                return Literal.ofUnchecked(this.returnType, this.returnType.explicitCast(value, txnCtx.sessionSettings()));
            }
            catch (ConversionException e) {
                throw e;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ConversionException(argument, this.returnType);
            }
        }
        return symbol;
    }
}

