/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.conditional;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.TypeSignature;
import java.util.List;

public class CaseFunction
extends Scalar<Object, Object> {
    public static final String NAME = "case";

    public static void register(Functions.Builder module) {
        TypeSignature t = TypeSignature.parse("T");
        TypeSignature bool = TypeSignature.parse("boolean");
        module.add(Signature.builder(new FunctionName(null, NAME), FunctionType.SCALAR).typeVariableConstraints(TypeVariableConstraint.typeVariable("T")).argumentTypes(bool, t).returnType(t).variableArityGroup(List.of(bool, t)).features(Scalar.Feature.DETERMINISTIC).build(), CaseFunction::new);
    }

    private CaseFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        for (int i = 2; i < args.length; i += 2) {
            Boolean condition = (Boolean)args[i].value();
            if (condition == null || !condition.booleanValue()) continue;
            return args[i + 1].value();
        }
        return args[1].value();
    }
}

