/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.geo.GeoJSONUtils;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.GeoShapeType;
import java.util.Map;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public final class AreaFunction {
    public static final String FUNCTION_NAME = "area";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(FUNCTION_NAME, FunctionType.SCALAR).argumentTypes(DataTypes.GEO_SHAPE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Double, Map>((Signature)signature, (BoundSignature)boundSignature, DataTypes.GEO_SHAPE, AreaFunction::getArea));
    }

    protected static Double getArea(Object value) {
        Object shapeAsMap = GeoShapeType.INSTANCE.sanitizeValue(value);
        Shape shape = GeoJSONUtils.map2Shape((Map<String, Object>)shapeAsMap);
        return shape.getArea((SpatialContext)JtsSpatialContext.GEO);
    }
}

