/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.common.Hex;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.common.hash.MessageDigests;

public final class HashFunctions {
    public static void register(Functions.Builder builder) {
        HashFunctions.register(builder, "md5", HashMethod.MD5::digest);
        HashFunctions.register(builder, "sha1", HashMethod.SHA1::digest);
    }

    private static void register(Functions.Builder builder, String name, UnaryOperator<String> func) {
        builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar((Signature)signature, (BoundSignature)boundSignature, DataTypes.STRING, func));
    }

    private static enum HashMethod {
        MD5(MessageDigests::md5),
        SHA1(MessageDigests::sha1);

        private final Supplier<MessageDigest> messageDigestSupplier;

        private HashMethod(Supplier<MessageDigest> digestSupplier) {
            this.messageDigestSupplier = digestSupplier;
        }

        public String digest(String input) {
            MessageDigest messageDigest = this.messageDigestSupplier.get();
            byte[] result = messageDigest.digest(input.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])result);
        }
    }
}

