/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;

public final class ParseURLFunction
extends Scalar<Object, String> {
    private static final String NAME = "parse_url";
    private static final ObjectType RETURN_TYPE = ObjectType.of(ColumnPolicy.DYNAMIC).setInnerType("scheme", DataTypes.STRING).setInnerType("userinfo", DataTypes.STRING).setInnerType("hostname", DataTypes.STRING).setInnerType("port", DataTypes.INTEGER).setInnerType("path", DataTypes.STRING).setInnerType("query", DataTypes.STRING).setInnerType("fragment", DataTypes.STRING).setInnerType("parameters", ObjectType.of(ColumnPolicy.DYNAMIC).build()).build();

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ParseURLFunction::new);
    }

    public ParseURLFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
        String url = (String)args[0].value();
        if (url == null) {
            return null;
        }
        return ParseURLFunction.parseURL(url);
    }

    private static Object parseURL(String urlText) {
        URL url;
        HashMap<String, Object> urlMap = new HashMap<String, Object>();
        try {
            url = URL.of(new URI(urlText), null);
        }
        catch (MalformedURLException | URISyntaxException e1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "unable to parse url %s", urlText));
        }
        urlMap.put("scheme", url.getProtocol());
        urlMap.put("userinfo", ParseURLFunction.decodeText(url.getUserInfo()));
        urlMap.put("hostname", url.getHost());
        urlMap.put("port", url.getPort() == -1 ? null : Integer.valueOf(url.getPort()));
        urlMap.put("path", ParseURLFunction.decodeText(url.getPath()));
        urlMap.put("query", ParseURLFunction.decodeText(url.getQuery()));
        urlMap.put("parameters", ParseURLFunction.parseQuery(url.getQuery()));
        urlMap.put("fragment", ParseURLFunction.decodeText(url.getRef()));
        return urlMap;
    }

    private static Map<String, List<String>> parseQuery(String query) {
        String[] parameters;
        if (Strings.isNullOrEmpty(query)) {
            return null;
        }
        HashMap<String, List<String>> queryMap = new HashMap<String, List<String>>();
        for (String parameter : parameters = query.split("&(?!amp)")) {
            int idx = parameter.indexOf("=");
            String key = idx > 0 ? ParseURLFunction.decodeText(parameter.substring(0, idx)) : ParseURLFunction.decodeText(parameter);
            String value = idx > 0 && parameter.length() > idx + 1 ? ParseURLFunction.decodeText(parameter.substring(idx + 1)) : null;
            queryMap.computeIfAbsent(key, string -> new ArrayList()).add(value);
        }
        return queryMap;
    }

    private static String decodeText(String text) {
        return text != null ? URLDecoder.decode(text, StandardCharsets.UTF_8) : null;
    }
}

