/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.timestamp;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Locale;

public class CurrentTimestampFunction
extends Scalar<Long, Integer> {
    public static final String NAME = "current_timestamp";
    public static final int DEFAULT_PRECISION = 3;

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), CurrentTimestampFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), CurrentTimestampFunction::new);
    }

    public CurrentTimestampFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Integer> ... args) {
        Integer precision = 3;
        if (args.length == 1 && (precision = (Integer)args[0].value()) == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "NULL precision not supported for %s", NAME));
        }
        return CurrentTimestampFunction.applyPrecision(ChronoUnit.MILLIS.between(Instant.EPOCH, txnCtx.currentInstant()), precision);
    }

    private static long applyPrecision(long millis, int precision) {
        int factor;
        switch (precision) {
            case 0: {
                factor = 1000;
                break;
            }
            case 1: {
                factor = 100;
                break;
            }
            case 2: {
                factor = 10;
                break;
            }
            case 3: {
                return millis;
            }
            default: {
                throw new IllegalArgumentException("Precision must be between 0 and 3");
            }
        }
        return Math.floorDiv(millis, factor) * (long)factor;
    }
}

